/**
 * Copyright (c) 2000-2011 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.asset.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

/**
 * The base model interface for the AssetCategory service. Represents a row in the &quot;AssetCategory&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.asset.model.impl.AssetCategoryModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.asset.model.impl.AssetCategoryImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a asset category model instance should use the {@link AssetCategory} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetCategory
 * @see com.liferay.portlet.asset.model.impl.AssetCategoryImpl
 * @see com.liferay.portlet.asset.model.impl.AssetCategoryModelImpl
 * @generated
 */
public interface AssetCategoryModel extends BaseModel<AssetCategory> {
	/**
	 * Gets the primary key of this asset category.
	 *
	 * @return the primary key of this asset category
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this asset category
	 *
	 * @param pk the primary key of this asset category
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the uuid of this asset category.
	 *
	 * @return the uuid of this asset category
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this asset category.
	 *
	 * @param uuid the uuid of this asset category
	 */
	public void setUuid(String uuid);

	/**
	 * Gets the category id of this asset category.
	 *
	 * @return the category id of this asset category
	 */
	public long getCategoryId();

	/**
	 * Sets the category id of this asset category.
	 *
	 * @param categoryId the category id of this asset category
	 */
	public void setCategoryId(long categoryId);

	/**
	 * Gets the group id of this asset category.
	 *
	 * @return the group id of this asset category
	 */
	public long getGroupId();

	/**
	 * Sets the group id of this asset category.
	 *
	 * @param groupId the group id of this asset category
	 */
	public void setGroupId(long groupId);

	/**
	 * Gets the company id of this asset category.
	 *
	 * @return the company id of this asset category
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this asset category.
	 *
	 * @param companyId the company id of this asset category
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the user id of this asset category.
	 *
	 * @return the user id of this asset category
	 */
	public long getUserId();

	/**
	 * Sets the user id of this asset category.
	 *
	 * @param userId the user id of this asset category
	 */
	public void setUserId(long userId);

	/**
	 * Gets the user uuid of this asset category.
	 *
	 * @return the user uuid of this asset category
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this asset category.
	 *
	 * @param userUuid the user uuid of this asset category
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Gets the user name of this asset category.
	 *
	 * @return the user name of this asset category
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this asset category.
	 *
	 * @param userName the user name of this asset category
	 */
	public void setUserName(String userName);

	/**
	 * Gets the create date of this asset category.
	 *
	 * @return the create date of this asset category
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this asset category.
	 *
	 * @param createDate the create date of this asset category
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Gets the modified date of this asset category.
	 *
	 * @return the modified date of this asset category
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this asset category.
	 *
	 * @param modifiedDate the modified date of this asset category
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Gets the parent category id of this asset category.
	 *
	 * @return the parent category id of this asset category
	 */
	public long getParentCategoryId();

	/**
	 * Sets the parent category id of this asset category.
	 *
	 * @param parentCategoryId the parent category id of this asset category
	 */
	public void setParentCategoryId(long parentCategoryId);

	/**
	 * Gets the left category id of this asset category.
	 *
	 * @return the left category id of this asset category
	 */
	public long getLeftCategoryId();

	/**
	 * Sets the left category id of this asset category.
	 *
	 * @param leftCategoryId the left category id of this asset category
	 */
	public void setLeftCategoryId(long leftCategoryId);

	/**
	 * Gets the right category id of this asset category.
	 *
	 * @return the right category id of this asset category
	 */
	public long getRightCategoryId();

	/**
	 * Sets the right category id of this asset category.
	 *
	 * @param rightCategoryId the right category id of this asset category
	 */
	public void setRightCategoryId(long rightCategoryId);

	/**
	 * Gets the name of this asset category.
	 *
	 * @return the name of this asset category
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this asset category.
	 *
	 * @param name the name of this asset category
	 */
	public void setName(String name);

	/**
	 * Gets the title of this asset category.
	 *
	 * @return the title of this asset category
	 */
	public String getTitle();

	/**
	 * Gets the localized title of this asset category. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale to get the localized title for
	 * @return the localized title of this asset category
	 */
	public String getTitle(Locale locale);

	/**
	 * Gets the localized title of this asset category, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local to get the localized title for
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this asset category. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	public String getTitle(Locale locale, boolean useDefault);

	/**
	 * Gets the localized title of this asset category. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the id of the language to get the localized title for
	 * @return the localized title of this asset category
	 */
	public String getTitle(String languageId);

	/**
	 * Gets the localized title of this asset category, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the id of the language to get the localized title for
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this asset category
	 */
	public String getTitle(String languageId, boolean useDefault);

	/**
	 * Gets a map of the locales and localized title of this asset category.
	 *
	 * @return the locales and localized title
	 */
	public Map<Locale, String> getTitleMap();

	/**
	 * Sets the title of this asset category.
	 *
	 * @param title the title of this asset category
	 */
	public void setTitle(String title);

	/**
	 * Sets the localized title of this asset category.
	 *
	 * @param locale the locale to set the localized title for
	 * @param title the localized title of this asset category
	 */
	public void setTitle(Locale locale, String title);

	/**
	 * Sets the localized titles of this asset category from the map of locales and localized titles.
	 *
	 * @param titleMap the locales and localized titles of this asset category
	 */
	public void setTitleMap(Map<Locale, String> titleMap);

	/**
	 * Gets the vocabulary id of this asset category.
	 *
	 * @return the vocabulary id of this asset category
	 */
	public long getVocabularyId();

	/**
	 * Sets the vocabulary id of this asset category.
	 *
	 * @param vocabularyId the vocabulary id of this asset category
	 */
	public void setVocabularyId(long vocabularyId);

	/**
	 * Gets a copy of this asset category as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public AssetCategory toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(AssetCategory assetCategory);

	public int hashCode();

	public String toString();

	public String toXmlString();
}