/**
 * Copyright (c) 2000-2011 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the Organization service. Represents a row in the &quot;Organization_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portal.model.impl.OrganizationModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portal.model.impl.OrganizationImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a organization model instance should use the {@link Organization} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see Organization
 * @see com.liferay.portal.model.impl.OrganizationImpl
 * @see com.liferay.portal.model.impl.OrganizationModelImpl
 * @generated
 */
public interface OrganizationModel extends BaseModel<Organization> {
	/**
	 * Gets the primary key of this organization.
	 *
	 * @return the primary key of this organization
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this organization
	 *
	 * @param pk the primary key of this organization
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the organization id of this organization.
	 *
	 * @return the organization id of this organization
	 */
	public long getOrganizationId();

	/**
	 * Sets the organization id of this organization.
	 *
	 * @param organizationId the organization id of this organization
	 */
	public void setOrganizationId(long organizationId);

	/**
	 * Gets the company id of this organization.
	 *
	 * @return the company id of this organization
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this organization.
	 *
	 * @param companyId the company id of this organization
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the parent organization id of this organization.
	 *
	 * @return the parent organization id of this organization
	 */
	public long getParentOrganizationId();

	/**
	 * Sets the parent organization id of this organization.
	 *
	 * @param parentOrganizationId the parent organization id of this organization
	 */
	public void setParentOrganizationId(long parentOrganizationId);

	/**
	 * Gets the left organization id of this organization.
	 *
	 * @return the left organization id of this organization
	 */
	public long getLeftOrganizationId();

	/**
	 * Sets the left organization id of this organization.
	 *
	 * @param leftOrganizationId the left organization id of this organization
	 */
	public void setLeftOrganizationId(long leftOrganizationId);

	/**
	 * Gets the right organization id of this organization.
	 *
	 * @return the right organization id of this organization
	 */
	public long getRightOrganizationId();

	/**
	 * Sets the right organization id of this organization.
	 *
	 * @param rightOrganizationId the right organization id of this organization
	 */
	public void setRightOrganizationId(long rightOrganizationId);

	/**
	 * Gets the name of this organization.
	 *
	 * @return the name of this organization
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this organization.
	 *
	 * @param name the name of this organization
	 */
	public void setName(String name);

	/**
	 * Gets the type of this organization.
	 *
	 * @return the type of this organization
	 */
	public String getType();

	/**
	 * Sets the type of this organization.
	 *
	 * @param type the type of this organization
	 */
	public void setType(String type);

	/**
	 * Gets the recursable of this organization.
	 *
	 * @return the recursable of this organization
	 */
	public boolean getRecursable();

	/**
	 * Determines if this organization is recursable.
	 *
	 * @return <code>true</code> if this organization is recursable; <code>false</code> otherwise
	 */
	public boolean isRecursable();

	/**
	 * Sets whether this {$entity.humanName} is recursable.
	 *
	 * @param recursable the recursable of this organization
	 */
	public void setRecursable(boolean recursable);

	/**
	 * Gets the region id of this organization.
	 *
	 * @return the region id of this organization
	 */
	public long getRegionId();

	/**
	 * Sets the region id of this organization.
	 *
	 * @param regionId the region id of this organization
	 */
	public void setRegionId(long regionId);

	/**
	 * Gets the country id of this organization.
	 *
	 * @return the country id of this organization
	 */
	public long getCountryId();

	/**
	 * Sets the country id of this organization.
	 *
	 * @param countryId the country id of this organization
	 */
	public void setCountryId(long countryId);

	/**
	 * Gets the status id of this organization.
	 *
	 * @return the status id of this organization
	 */
	public int getStatusId();

	/**
	 * Sets the status id of this organization.
	 *
	 * @param statusId the status id of this organization
	 */
	public void setStatusId(int statusId);

	/**
	 * Gets the comments of this organization.
	 *
	 * @return the comments of this organization
	 */
	@AutoEscape
	public String getComments();

	/**
	 * Sets the comments of this organization.
	 *
	 * @param comments the comments of this organization
	 */
	public void setComments(String comments);

	/**
	 * Gets a copy of this organization as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public Organization toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Organization organization);

	public int hashCode();

	public String toString();

	public String toXmlString();
}