/**
 * Copyright (c) 2000-2011 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Lock service. Represents a row in the &quot;Lock_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portal.model.impl.LockModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portal.model.impl.LockImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a lock model instance should use the {@link Lock} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see Lock
 * @see com.liferay.portal.model.impl.LockImpl
 * @see com.liferay.portal.model.impl.LockModelImpl
 * @generated
 */
public interface LockModel extends BaseModel<Lock> {
	/**
	 * Gets the primary key of this lock.
	 *
	 * @return the primary key of this lock
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this lock
	 *
	 * @param pk the primary key of this lock
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the uuid of this lock.
	 *
	 * @return the uuid of this lock
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this lock.
	 *
	 * @param uuid the uuid of this lock
	 */
	public void setUuid(String uuid);

	/**
	 * Gets the lock id of this lock.
	 *
	 * @return the lock id of this lock
	 */
	public long getLockId();

	/**
	 * Sets the lock id of this lock.
	 *
	 * @param lockId the lock id of this lock
	 */
	public void setLockId(long lockId);

	/**
	 * Gets the company id of this lock.
	 *
	 * @return the company id of this lock
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this lock.
	 *
	 * @param companyId the company id of this lock
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the user id of this lock.
	 *
	 * @return the user id of this lock
	 */
	public long getUserId();

	/**
	 * Sets the user id of this lock.
	 *
	 * @param userId the user id of this lock
	 */
	public void setUserId(long userId);

	/**
	 * Gets the user uuid of this lock.
	 *
	 * @return the user uuid of this lock
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this lock.
	 *
	 * @param userUuid the user uuid of this lock
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Gets the user name of this lock.
	 *
	 * @return the user name of this lock
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this lock.
	 *
	 * @param userName the user name of this lock
	 */
	public void setUserName(String userName);

	/**
	 * Gets the create date of this lock.
	 *
	 * @return the create date of this lock
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this lock.
	 *
	 * @param createDate the create date of this lock
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Gets the class name of this lock.
	 *
	 * @return the class name of this lock
	 */
	@AutoEscape
	public String getClassName();

	/**
	 * Sets the class name of this lock.
	 *
	 * @param className the class name of this lock
	 */
	public void setClassName(String className);

	/**
	 * Gets the key of this lock.
	 *
	 * @return the key of this lock
	 */
	@AutoEscape
	public String getKey();

	/**
	 * Sets the key of this lock.
	 *
	 * @param key the key of this lock
	 */
	public void setKey(String key);

	/**
	 * Gets the owner of this lock.
	 *
	 * @return the owner of this lock
	 */
	@AutoEscape
	public String getOwner();

	/**
	 * Sets the owner of this lock.
	 *
	 * @param owner the owner of this lock
	 */
	public void setOwner(String owner);

	/**
	 * Gets the inheritable of this lock.
	 *
	 * @return the inheritable of this lock
	 */
	public boolean getInheritable();

	/**
	 * Determines if this lock is inheritable.
	 *
	 * @return <code>true</code> if this lock is inheritable; <code>false</code> otherwise
	 */
	public boolean isInheritable();

	/**
	 * Sets whether this {$entity.humanName} is inheritable.
	 *
	 * @param inheritable the inheritable of this lock
	 */
	public void setInheritable(boolean inheritable);

	/**
	 * Gets the expiration date of this lock.
	 *
	 * @return the expiration date of this lock
	 */
	public Date getExpirationDate();

	/**
	 * Sets the expiration date of this lock.
	 *
	 * @param expirationDate the expiration date of this lock
	 */
	public void setExpirationDate(Date expirationDate);

	/**
	 * Gets a copy of this lock as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public Lock toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Lock lock);

	public int hashCode();

	public String toString();

	public String toXmlString();
}