/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.tasks.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the TasksProposal service. Represents a row in the &quot;TasksProposal&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.tasks.model.impl.TasksProposalModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.tasks.model.impl.TasksProposalImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a tasks proposal model instance should use the {@link TasksProposal} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TasksProposal
 * @see com.liferay.portlet.tasks.model.impl.TasksProposalImpl
 * @see com.liferay.portlet.tasks.model.impl.TasksProposalModelImpl
 * @generated
 */
public interface TasksProposalModel extends BaseModel<TasksProposal> {
	/**
	 * Gets the primary key of this tasks proposal.
	 *
	 * @return the primary key of this tasks proposal
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this tasks proposal
	 *
	 * @param pk the primary key of this tasks proposal
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the proposal id of this tasks proposal.
	 *
	 * @return the proposal id of this tasks proposal
	 */
	public long getProposalId();

	/**
	 * Sets the proposal id of this tasks proposal.
	 *
	 * @param proposalId the proposal id of this tasks proposal
	 */
	public void setProposalId(long proposalId);

	/**
	 * Gets the group id of this tasks proposal.
	 *
	 * @return the group id of this tasks proposal
	 */
	public long getGroupId();

	/**
	 * Sets the group id of this tasks proposal.
	 *
	 * @param groupId the group id of this tasks proposal
	 */
	public void setGroupId(long groupId);

	/**
	 * Gets the company id of this tasks proposal.
	 *
	 * @return the company id of this tasks proposal
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this tasks proposal.
	 *
	 * @param companyId the company id of this tasks proposal
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the user id of this tasks proposal.
	 *
	 * @return the user id of this tasks proposal
	 */
	public long getUserId();

	/**
	 * Sets the user id of this tasks proposal.
	 *
	 * @param userId the user id of this tasks proposal
	 */
	public void setUserId(long userId);

	/**
	 * Gets the user uuid of this tasks proposal.
	 *
	 * @return the user uuid of this tasks proposal
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this tasks proposal.
	 *
	 * @param userUuid the user uuid of this tasks proposal
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Gets the user name of this tasks proposal.
	 *
	 * @return the user name of this tasks proposal
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this tasks proposal.
	 *
	 * @param userName the user name of this tasks proposal
	 */
	public void setUserName(String userName);

	/**
	 * Gets the create date of this tasks proposal.
	 *
	 * @return the create date of this tasks proposal
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this tasks proposal.
	 *
	 * @param createDate the create date of this tasks proposal
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Gets the modified date of this tasks proposal.
	 *
	 * @return the modified date of this tasks proposal
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this tasks proposal.
	 *
	 * @param modifiedDate the modified date of this tasks proposal
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Gets the class name of the model instance this tasks proposal is polymorphically associated with.
	 *
	 * @return the class name of the model instance this tasks proposal is polymorphically associated with
	 */
	public String getClassName();

	/**
	 * Gets the class name id of this tasks proposal.
	 *
	 * @return the class name id of this tasks proposal
	 */
	public long getClassNameId();

	/**
	 * Sets the class name id of this tasks proposal.
	 *
	 * @param classNameId the class name id of this tasks proposal
	 */
	public void setClassNameId(long classNameId);

	/**
	 * Gets the class p k of this tasks proposal.
	 *
	 * @return the class p k of this tasks proposal
	 */
	@AutoEscape
	public String getClassPK();

	/**
	 * Sets the class p k of this tasks proposal.
	 *
	 * @param classPK the class p k of this tasks proposal
	 */
	public void setClassPK(String classPK);

	/**
	 * Gets the name of this tasks proposal.
	 *
	 * @return the name of this tasks proposal
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this tasks proposal.
	 *
	 * @param name the name of this tasks proposal
	 */
	public void setName(String name);

	/**
	 * Gets the description of this tasks proposal.
	 *
	 * @return the description of this tasks proposal
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this tasks proposal.
	 *
	 * @param description the description of this tasks proposal
	 */
	public void setDescription(String description);

	/**
	 * Gets the publish date of this tasks proposal.
	 *
	 * @return the publish date of this tasks proposal
	 */
	public Date getPublishDate();

	/**
	 * Sets the publish date of this tasks proposal.
	 *
	 * @param publishDate the publish date of this tasks proposal
	 */
	public void setPublishDate(Date publishDate);

	/**
	 * Gets the due date of this tasks proposal.
	 *
	 * @return the due date of this tasks proposal
	 */
	public Date getDueDate();

	/**
	 * Sets the due date of this tasks proposal.
	 *
	 * @param dueDate the due date of this tasks proposal
	 */
	public void setDueDate(Date dueDate);

	/**
	 * Gets a copy of this tasks proposal as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public TasksProposal toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(TasksProposal tasksProposal);

	public int hashCode();

	public String toString();

	public String toXmlString();
}