/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.shopping.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the ShoppingCoupon service. Represents a row in the &quot;ShoppingCoupon&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.shopping.model.impl.ShoppingCouponModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.shopping.model.impl.ShoppingCouponImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a shopping coupon model instance should use the {@link ShoppingCoupon} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ShoppingCoupon
 * @see com.liferay.portlet.shopping.model.impl.ShoppingCouponImpl
 * @see com.liferay.portlet.shopping.model.impl.ShoppingCouponModelImpl
 * @generated
 */
public interface ShoppingCouponModel extends BaseModel<ShoppingCoupon> {
	/**
	 * Gets the primary key of this shopping coupon.
	 *
	 * @return the primary key of this shopping coupon
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this shopping coupon
	 *
	 * @param pk the primary key of this shopping coupon
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the coupon id of this shopping coupon.
	 *
	 * @return the coupon id of this shopping coupon
	 */
	public long getCouponId();

	/**
	 * Sets the coupon id of this shopping coupon.
	 *
	 * @param couponId the coupon id of this shopping coupon
	 */
	public void setCouponId(long couponId);

	/**
	 * Gets the group id of this shopping coupon.
	 *
	 * @return the group id of this shopping coupon
	 */
	public long getGroupId();

	/**
	 * Sets the group id of this shopping coupon.
	 *
	 * @param groupId the group id of this shopping coupon
	 */
	public void setGroupId(long groupId);

	/**
	 * Gets the company id of this shopping coupon.
	 *
	 * @return the company id of this shopping coupon
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this shopping coupon.
	 *
	 * @param companyId the company id of this shopping coupon
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the user id of this shopping coupon.
	 *
	 * @return the user id of this shopping coupon
	 */
	public long getUserId();

	/**
	 * Sets the user id of this shopping coupon.
	 *
	 * @param userId the user id of this shopping coupon
	 */
	public void setUserId(long userId);

	/**
	 * Gets the user uuid of this shopping coupon.
	 *
	 * @return the user uuid of this shopping coupon
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this shopping coupon.
	 *
	 * @param userUuid the user uuid of this shopping coupon
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Gets the user name of this shopping coupon.
	 *
	 * @return the user name of this shopping coupon
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this shopping coupon.
	 *
	 * @param userName the user name of this shopping coupon
	 */
	public void setUserName(String userName);

	/**
	 * Gets the create date of this shopping coupon.
	 *
	 * @return the create date of this shopping coupon
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this shopping coupon.
	 *
	 * @param createDate the create date of this shopping coupon
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Gets the modified date of this shopping coupon.
	 *
	 * @return the modified date of this shopping coupon
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this shopping coupon.
	 *
	 * @param modifiedDate the modified date of this shopping coupon
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Gets the code of this shopping coupon.
	 *
	 * @return the code of this shopping coupon
	 */
	@AutoEscape
	public String getCode();

	/**
	 * Sets the code of this shopping coupon.
	 *
	 * @param code the code of this shopping coupon
	 */
	public void setCode(String code);

	/**
	 * Gets the name of this shopping coupon.
	 *
	 * @return the name of this shopping coupon
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this shopping coupon.
	 *
	 * @param name the name of this shopping coupon
	 */
	public void setName(String name);

	/**
	 * Gets the description of this shopping coupon.
	 *
	 * @return the description of this shopping coupon
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this shopping coupon.
	 *
	 * @param description the description of this shopping coupon
	 */
	public void setDescription(String description);

	/**
	 * Gets the start date of this shopping coupon.
	 *
	 * @return the start date of this shopping coupon
	 */
	public Date getStartDate();

	/**
	 * Sets the start date of this shopping coupon.
	 *
	 * @param startDate the start date of this shopping coupon
	 */
	public void setStartDate(Date startDate);

	/**
	 * Gets the end date of this shopping coupon.
	 *
	 * @return the end date of this shopping coupon
	 */
	public Date getEndDate();

	/**
	 * Sets the end date of this shopping coupon.
	 *
	 * @param endDate the end date of this shopping coupon
	 */
	public void setEndDate(Date endDate);

	/**
	 * Gets the active of this shopping coupon.
	 *
	 * @return the active of this shopping coupon
	 */
	public boolean getActive();

	/**
	 * Determines whether this shopping coupon is active.
	 *
	 * @return whether this shopping coupon is active
	 */
	public boolean isActive();

	/**
	 * Sets whether this {$entity.humanName} is active.
	 *
	 * @param active the active of this shopping coupon
	 */
	public void setActive(boolean active);

	/**
	 * Gets the limit categories of this shopping coupon.
	 *
	 * @return the limit categories of this shopping coupon
	 */
	@AutoEscape
	public String getLimitCategories();

	/**
	 * Sets the limit categories of this shopping coupon.
	 *
	 * @param limitCategories the limit categories of this shopping coupon
	 */
	public void setLimitCategories(String limitCategories);

	/**
	 * Gets the limit skus of this shopping coupon.
	 *
	 * @return the limit skus of this shopping coupon
	 */
	@AutoEscape
	public String getLimitSkus();

	/**
	 * Sets the limit skus of this shopping coupon.
	 *
	 * @param limitSkus the limit skus of this shopping coupon
	 */
	public void setLimitSkus(String limitSkus);

	/**
	 * Gets the min order of this shopping coupon.
	 *
	 * @return the min order of this shopping coupon
	 */
	public double getMinOrder();

	/**
	 * Sets the min order of this shopping coupon.
	 *
	 * @param minOrder the min order of this shopping coupon
	 */
	public void setMinOrder(double minOrder);

	/**
	 * Gets the discount of this shopping coupon.
	 *
	 * @return the discount of this shopping coupon
	 */
	public double getDiscount();

	/**
	 * Sets the discount of this shopping coupon.
	 *
	 * @param discount the discount of this shopping coupon
	 */
	public void setDiscount(double discount);

	/**
	 * Gets the discount type of this shopping coupon.
	 *
	 * @return the discount type of this shopping coupon
	 */
	@AutoEscape
	public String getDiscountType();

	/**
	 * Sets the discount type of this shopping coupon.
	 *
	 * @param discountType the discount type of this shopping coupon
	 */
	public void setDiscountType(String discountType);

	/**
	 * Gets a copy of this shopping coupon as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public ShoppingCoupon toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(ShoppingCoupon shoppingCoupon);

	public int hashCode();

	public String toString();

	public String toXmlString();
}