/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.journal.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the JournalArticleResource service. Represents a row in the &quot;JournalArticleResource&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.journal.model.impl.JournalArticleResourceModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.journal.model.impl.JournalArticleResourceImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a journal article resource model instance should use the {@link JournalArticleResource} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalArticleResource
 * @see com.liferay.portlet.journal.model.impl.JournalArticleResourceImpl
 * @see com.liferay.portlet.journal.model.impl.JournalArticleResourceModelImpl
 * @generated
 */
public interface JournalArticleResourceModel extends BaseModel<JournalArticleResource> {
	/**
	 * Gets the primary key of this journal article resource.
	 *
	 * @return the primary key of this journal article resource
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this journal article resource
	 *
	 * @param pk the primary key of this journal article resource
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the resource prim key of this journal article resource.
	 *
	 * @return the resource prim key of this journal article resource
	 */
	public long getResourcePrimKey();

	/**
	 * Sets the resource prim key of this journal article resource.
	 *
	 * @param resourcePrimKey the resource prim key of this journal article resource
	 */
	public void setResourcePrimKey(long resourcePrimKey);

	/**
	 * Gets the group id of this journal article resource.
	 *
	 * @return the group id of this journal article resource
	 */
	public long getGroupId();

	/**
	 * Sets the group id of this journal article resource.
	 *
	 * @param groupId the group id of this journal article resource
	 */
	public void setGroupId(long groupId);

	/**
	 * Gets the article id of this journal article resource.
	 *
	 * @return the article id of this journal article resource
	 */
	@AutoEscape
	public String getArticleId();

	/**
	 * Sets the article id of this journal article resource.
	 *
	 * @param articleId the article id of this journal article resource
	 */
	public void setArticleId(String articleId);

	/**
	 * Gets a copy of this journal article resource as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public JournalArticleResource toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(JournalArticleResource journalArticleResource);

	public int hashCode();

	public String toString();

	public String toXmlString();
}