/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.expando.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import java.io.Serializable;

/**
 * The base model interface for the ExpandoValue service. Represents a row in the &quot;ExpandoValue&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.expando.model.impl.ExpandoValueModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.expando.model.impl.ExpandoValueImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a expando value model instance should use the {@link ExpandoValue} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ExpandoValue
 * @see com.liferay.portlet.expando.model.impl.ExpandoValueImpl
 * @see com.liferay.portlet.expando.model.impl.ExpandoValueModelImpl
 * @generated
 */
public interface ExpandoValueModel extends BaseModel<ExpandoValue> {
	/**
	 * Gets the primary key of this expando value.
	 *
	 * @return the primary key of this expando value
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this expando value
	 *
	 * @param pk the primary key of this expando value
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the value id of this expando value.
	 *
	 * @return the value id of this expando value
	 */
	public long getValueId();

	/**
	 * Sets the value id of this expando value.
	 *
	 * @param valueId the value id of this expando value
	 */
	public void setValueId(long valueId);

	/**
	 * Gets the company id of this expando value.
	 *
	 * @return the company id of this expando value
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this expando value.
	 *
	 * @param companyId the company id of this expando value
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the table id of this expando value.
	 *
	 * @return the table id of this expando value
	 */
	public long getTableId();

	/**
	 * Sets the table id of this expando value.
	 *
	 * @param tableId the table id of this expando value
	 */
	public void setTableId(long tableId);

	/**
	 * Gets the column id of this expando value.
	 *
	 * @return the column id of this expando value
	 */
	public long getColumnId();

	/**
	 * Sets the column id of this expando value.
	 *
	 * @param columnId the column id of this expando value
	 */
	public void setColumnId(long columnId);

	/**
	 * Gets the row id of this expando value.
	 *
	 * @return the row id of this expando value
	 */
	public long getRowId();

	/**
	 * Sets the row id of this expando value.
	 *
	 * @param rowId the row id of this expando value
	 */
	public void setRowId(long rowId);

	/**
	 * Gets the class name of the model instance this expando value is polymorphically associated with.
	 *
	 * @return the class name of the model instance this expando value is polymorphically associated with
	 */
	public String getClassName();

	/**
	 * Gets the class name id of this expando value.
	 *
	 * @return the class name id of this expando value
	 */
	public long getClassNameId();

	/**
	 * Sets the class name id of this expando value.
	 *
	 * @param classNameId the class name id of this expando value
	 */
	public void setClassNameId(long classNameId);

	/**
	 * Gets the class p k of this expando value.
	 *
	 * @return the class p k of this expando value
	 */
	public long getClassPK();

	/**
	 * Sets the class p k of this expando value.
	 *
	 * @param classPK the class p k of this expando value
	 */
	public void setClassPK(long classPK);

	/**
	 * Gets the data of this expando value.
	 *
	 * @return the data of this expando value
	 */
	@AutoEscape
	public String getData();

	/**
	 * Sets the data of this expando value.
	 *
	 * @param data the data of this expando value
	 */
	public void setData(String data);

	/**
	 * Gets a copy of this expando value as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public ExpandoValue toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(ExpandoValue expandoValue);

	public int hashCode();

	public String toString();

	public String toXmlString();
}