/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the WebDAVProps service. Represents a row in the &quot;WebDAVProps&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portal.model.impl.WebDAVPropsModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portal.model.impl.WebDAVPropsImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a web d a v props model instance should use the {@link WebDAVProps} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WebDAVProps
 * @see com.liferay.portal.model.impl.WebDAVPropsImpl
 * @see com.liferay.portal.model.impl.WebDAVPropsModelImpl
 * @generated
 */
public interface WebDAVPropsModel extends BaseModel<WebDAVProps> {
	/**
	 * Gets the primary key of this web d a v props.
	 *
	 * @return the primary key of this web d a v props
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this web d a v props
	 *
	 * @param pk the primary key of this web d a v props
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the web dav props id of this web d a v props.
	 *
	 * @return the web dav props id of this web d a v props
	 */
	public long getWebDavPropsId();

	/**
	 * Sets the web dav props id of this web d a v props.
	 *
	 * @param webDavPropsId the web dav props id of this web d a v props
	 */
	public void setWebDavPropsId(long webDavPropsId);

	/**
	 * Gets the company id of this web d a v props.
	 *
	 * @return the company id of this web d a v props
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this web d a v props.
	 *
	 * @param companyId the company id of this web d a v props
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the create date of this web d a v props.
	 *
	 * @return the create date of this web d a v props
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this web d a v props.
	 *
	 * @param createDate the create date of this web d a v props
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Gets the modified date of this web d a v props.
	 *
	 * @return the modified date of this web d a v props
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this web d a v props.
	 *
	 * @param modifiedDate the modified date of this web d a v props
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Gets the class name of the model instance this web d a v props is polymorphically associated with.
	 *
	 * @return the class name of the model instance this web d a v props is polymorphically associated with
	 */
	public String getClassName();

	/**
	 * Gets the class name id of this web d a v props.
	 *
	 * @return the class name id of this web d a v props
	 */
	public long getClassNameId();

	/**
	 * Sets the class name id of this web d a v props.
	 *
	 * @param classNameId the class name id of this web d a v props
	 */
	public void setClassNameId(long classNameId);

	/**
	 * Gets the class p k of this web d a v props.
	 *
	 * @return the class p k of this web d a v props
	 */
	public long getClassPK();

	/**
	 * Sets the class p k of this web d a v props.
	 *
	 * @param classPK the class p k of this web d a v props
	 */
	public void setClassPK(long classPK);

	/**
	 * Gets the props of this web d a v props.
	 *
	 * @return the props of this web d a v props
	 */
	@AutoEscape
	public String getProps();

	/**
	 * Sets the props of this web d a v props.
	 *
	 * @param props the props of this web d a v props
	 */
	public void setProps(String props);

	/**
	 * Gets a copy of this web d a v props as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public WebDAVProps toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(WebDAVProps webDAVProps);

	public int hashCode();

	public String toString();

	public String toXmlString();
}