/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import com.liferay.portal.kernel.annotation.AutoEscape;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the Shard service. Represents a row in the &quot;Shard&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portal.model.impl.ShardModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portal.model.impl.ShardImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a shard model instance should use the {@link Shard} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see Shard
 * @see com.liferay.portal.model.impl.ShardImpl
 * @see com.liferay.portal.model.impl.ShardModelImpl
 * @generated
 */
public interface ShardModel extends BaseModel<Shard> {
	/**
	 * Gets the primary key of this shard.
	 *
	 * @return the primary key of this shard
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this shard
	 *
	 * @param pk the primary key of this shard
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the shard id of this shard.
	 *
	 * @return the shard id of this shard
	 */
	public long getShardId();

	/**
	 * Sets the shard id of this shard.
	 *
	 * @param shardId the shard id of this shard
	 */
	public void setShardId(long shardId);

	/**
	 * Gets the class name of the model instance this shard is polymorphically associated with.
	 *
	 * @return the class name of the model instance this shard is polymorphically associated with
	 */
	public String getClassName();

	/**
	 * Gets the class name id of this shard.
	 *
	 * @return the class name id of this shard
	 */
	public long getClassNameId();

	/**
	 * Sets the class name id of this shard.
	 *
	 * @param classNameId the class name id of this shard
	 */
	public void setClassNameId(long classNameId);

	/**
	 * Gets the class p k of this shard.
	 *
	 * @return the class p k of this shard
	 */
	public long getClassPK();

	/**
	 * Sets the class p k of this shard.
	 *
	 * @param classPK the class p k of this shard
	 */
	public void setClassPK(long classPK);

	/**
	 * Gets the name of this shard.
	 *
	 * @return the name of this shard
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this shard.
	 *
	 * @param name the name of this shard
	 */
	public void setName(String name);

	/**
	 * Gets a copy of this shard as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public Shard toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Shard shard);

	public int hashCode();

	public String toString();

	public String toXmlString();
}