/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import com.liferay.portal.kernel.xml.QName;

import java.io.Serializable;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * <a href="PortletApp.java.html"><b><i>View Source</i></b></a>
 *
 * @author Brian Wing Shun Chan
 */
public interface PortletApp extends Serializable {

	public void addEventDefinition(EventDefinition eventDefinition);

	public void addPortletFilter(PortletFilter portletFilter);

	public void addPortletURLListener(PortletURLListener portletURLListener);

	public void addServletURLPatterns(Set<String> servletURLPatterns);

	public void addPublicRenderParameter(
		PublicRenderParameter publicRenderParameter);

	public void addPublicRenderParameter(String identifier, QName qName);

	public Map<String, String[]> getContainerRuntimeOptions();

	public Map<String, String> getCustomUserAttributes();

	public String getDefaultNamespace();

	public PortletFilter getPortletFilter(String filterName);

	public Set<PortletFilter> getPortletFilters();

	public PortletURLListener getPortletURLListener(String listenerClass);

	public Set<PortletURLListener> getPortletURLListeners();

	public PublicRenderParameter getPublicRenderParameter(String identifier);

	public String getServletContextName();

	public Set<String> getServletURLPatterns();

	public SpriteImage getSpriteImage(String fileName);

	public Set<String> getUserAttributes();

	public boolean isWARFile();

	public void setDefaultNamespace(String defaultNamespace);

	public void setSpriteImages(String spriteFileName, Properties properties);

	public void setWARFile(boolean warFile);

}