/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.util;

/**
 * <a href="StringPool.java.html"><b><i>View Source</i></b></a>
 *
 * @author Brian Wing Shun Chan
 */
public class StringPool {

	public static final String AMPERSAND = "&";

	public static final String AMPERSAND_ENCODED = "&amp;";

	public static final String APOSTROPHE = "'";

	public static final String AT = "@";

	public static final String BACK_SLASH = "\\";

	public static final String BETWEEN = "BETWEEN";

	public static final String BLANK = "";

	public static final String CARET = "^";

	public static final String CDATA_CLOSE = "]]>";

	public static final String CDATA_OPEN = "<![CDATA[";

	public static final String CLOSE_BRACKET = "]";

	public static final String CLOSE_CURLY_BRACE = "}";

	public static final String CLOSE_PARENTHESIS = ")";

	public static final String COLON = ":";

	public static final String COMMA = ",";

	public static final String COMMA_AND_SPACE = ", ";

	public static final String DASH = "-";

	public static final String DOLLAR = "$";

	public static final String DOLLAR_AND_OPEN_CURLY_BRACE = "${";

	public static final String DOUBLE_APOSTROPHE = "''";

	public static final String DOUBLE_CLOSE_BRACKET = "]]";

	public static final String DOUBLE_CLOSE_CURLY_BRACE = "}}";

	public static final String DOUBLE_OPEN_BRACKET = "[[";

	public static final String DOUBLE_OPEN_CURLY_BRACE = "{{";

	public static final String DOUBLE_PERIOD = "..";

	public static final String DOUBLE_QUOTE = "\"\"";

	public static final String DOUBLE_SLASH = "//";

	public static final String DOUBLE_SPACE = "  ";

	public static final String EXCLAMATION = "!";

	public static final String EQUAL = "=";

	public static final String FALSE = "false";

	public static final String FORWARD_SLASH = "/";

	public static final String FOUR_SPACES = "    ";

	public static final String GRAVE_ACCENT = "`";

	public static final String GREATER_THAN = ">";

	public static final String GREATER_THAN_OR_EQUAL = ">=";

	public static final String INVERTED_EXCLAMATION = "\u00A1";

	public static final String INVERTED_QUESTION = "\u00BF";

	public static final String IS_NOT_NULL = "IS NOT NULL";

	public static final String IS_NULL = "IS NULL";

	public static final String LESS_THAN = "<";

	public static final String LESS_THAN_OR_EQUAL = "<=";

	public static final String LIKE = "LIKE";

	public static final String MINUS = "-";

	public static final String NBSP = "&nbsp;";

	public static final String NEW_LINE = "\n";

	public static final String NOT_EQUAL = "!=";

	public static final String NOT_LIKE = "NOT LIKE";

	public static final String NULL = "null";

	public static final String OPEN_BRACKET = "[";

	public static final String OPEN_CURLY_BRACE = "{";

	public static final String OPEN_PARENTHESIS = "(";

	public static final String PERCENT = "%";

	public static final String PERIOD = ".";

	public static final String PIPE = "|";

	public static final String PLUS = "+";

	public static final String POUND = "#";

	public static final String QUESTION = "?";

	public static final String QUOTE = "\"";

	public static final String RETURN = "\r";

	public static final String RETURN_NEW_LINE = "\r\n";

	public static final String SEMICOLON = ";";

	public static final String SLASH = FORWARD_SLASH;

	public static final String SPACE = " ";

	public static final String STAR = "*";

	public static final String TAB = "\t";

	public static final String TILDE = "~";

	public static final String TRUE = "true";

	public static final String UNDERLINE = "_";

	public static final String UTC = "UTC";

	public static final String UTF8 = "UTF-8";

}