/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.util;

/**
 * <a href="DoubleWrapper.java.html"><b><i>View Source</i></b></a>
 *
 * @author Brian Wing Shun Chan
 */
public class DoubleWrapper
	extends PrimitiveWrapper implements Comparable<DoubleWrapper> {

	public static final Class<?> TYPE = Double.TYPE;

	public DoubleWrapper() {
		this(0D);
	}

	public DoubleWrapper(double value) {
		_value = value;
	}

	public int compareTo(DoubleWrapper doubleWrapper) {
		if (doubleWrapper == null) {
			return 1;
		}

		if (getValue() > doubleWrapper.getValue()) {
			return 1;
		}
		else if (getValue() < doubleWrapper.getValue()) {
			return -1;
		}
		else {
			return 0;
		}
	}

	public double getValue() {
		return _value;
	}

	public void setValue(double value) {
		_value = value;
	}

	public double increment() {
		return ++_value;
	}

	public double decrement() {
		return --_value;
	}

	private double _value;

}