/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.upgrade.util;

import java.util.Iterator;

/**
 * <a href="ValueMapperWrapper.java.html"><b><i>View Source</i></b></a>
 *
 * @author Brian Wing Shun Chan
 */
public class ValueMapperWrapper implements ValueMapper {

	public ValueMapperWrapper(ValueMapper valueMapper) {
		_valueMapper = valueMapper;
	}

	public ValueMapper getValueMapper() {
		return _valueMapper;
	}

	public Object getNewValue(Object oldValue) throws Exception {
		return _valueMapper.getNewValue(oldValue);
	}

	public void mapValue(Object oldValue, Object newValue) throws Exception {
		_valueMapper.mapValue(oldValue, newValue);
	}

	public void appendException(Object exception) {
		_valueMapper.appendException(exception);
	}

	public Iterator<Object> iterator() throws Exception {
		return _valueMapper.iterator();
	}

	public int size() throws Exception {
		return _valueMapper.size();
	}

	private ValueMapper _valueMapper;

}