/**
 * Copyright (c) 2000-2010 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.util.MethodWrapper;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

/**
 * <a href="ClusterExecutor.java.html"><b><i>View Source</i></b></a>
 *
 * @author Shuyang Zhou
 */
public interface ClusterExecutor {

	public Map<Address, Future<?>> executeMulticastCall(
		MethodWrapper methodWrapper);

	public Future<?> executeUnicastCall(
		Address address, MethodWrapper methodWrapper);

	public List<Address> getControlAddresses();

	public Address getLocalControlAddress();

	public boolean isEnabled();

	public boolean isShortcutLocalMethod();

}