/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.WikiFormatException;
import com.liferay.portlet.wiki.WikiPortletInstanceSettings;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.portlet.wiki.util.comparator.PageTitleComparator;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class WikiUtil {
    private static final String[] _ESCAPED_CHARS = new String[]{"<PLUS>", "<QUESTION>", "<SLASH>"};
    private static final String[] _UNESCAPED_CHARS = new String[]{"+", "?", "/"};
    private static Log _log = LogFactoryUtil.getLog(WikiUtil.class);
    private static WikiUtil _instance = new WikiUtil();
    private static Pattern _editPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE_EDIT\\$\\](.*?)\\[\\$END_PAGE_TITLE_EDIT\\$\\]");
    private static Pattern _viewPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE\\$\\](.*?)\\[\\$END_PAGE_TITLE\\$\\]");
    private Map<String, WikiEngine> _engines = new ConcurrentHashMap<String, WikiEngine>();

    public static String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        return _instance._convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public static String diffHtml(WikiPage sourcePage, WikiPage targetPage, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws Exception {
        String sourceContent = "";
        String targetContent = "";
        if (sourcePage != null) {
            sourceContent = WikiUtil.convert(sourcePage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        if (targetPage != null) {
            targetContent = WikiUtil.convert(targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        return DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
    }

    public static String escapeName(String name) {
        return StringUtil.replace((String)name, (String[])_UNESCAPED_CHARS, (String[])_ESCAPED_CHARS);
    }

    public static List<WikiPage> filterOrphans(List<WikiPage> pages) throws PortalException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        for (WikiPage page : pages) {
            pageTitles.add(WikiCacheUtil.getOutgoingLinks(page));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map : pageTitles) {
                String pageTitleLowerCase = page.getTitle();
                if (map.get(pageTitleLowerCase = StringUtil.toLowerCase((String)pageTitleLowerCase)) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> orphans = new ArrayList();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            orphans.add(page);
        }
        orphans = ListUtil.sort(orphans);
        return orphans;
    }

    public static String getAttachmentURLPrefix(String mainPath, long plid, long nodeId, String title) {
        StringBundler sb = new StringBundler(8);
        sb.append(mainPath);
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(plid);
        sb.append("&nodeId=");
        sb.append(nodeId);
        sb.append("&title=");
        sb.append(HttpUtil.encodeURL((String)title));
        sb.append("&fileName=");
        return sb.toString();
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long nodeId, String title, double sourceVersion, double targetVersion, HttpServletRequest request) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List pages = WikiPageLocalServiceUtil.getPages((long)nodeId, (String)title, (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator(true));
        for (WikiPage page : pages) {
            if (page.getVersion() < sourceVersion && page.getVersion() > previousVersion) {
                previousVersion = page.getVersion();
            }
            if (!(page.getVersion() > targetVersion) || !(page.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = page.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (WikiPage page : pages) {
            String extraInfo = "";
            if (page.isMinorEdit()) {
                extraInfo = LanguageUtil.get((HttpServletRequest)request, (String)"minor-edit");
            }
            DiffVersion diffVersion = new DiffVersion(page.getUserId(), page.getVersion(), page.getModifiedDate(), page.getSummary(), extraInfo);
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static String getEditPage(String format) {
        return _instance._getEditPage(format);
    }

    public static Map<String, String> getEmailFromDefinitionTerms(RenderRequest request, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-wiki"));
        definitionTerms.put("[$PAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-page"));
        definitionTerms.put("[$PAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-page"));
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)request));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-wiki"));
        return definitionTerms;
    }

    public static Map<String, String> getEmailNotificationDefinitionTerms(RenderRequest request, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-wiki"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-wiki"));
        definitionTerms.put("[$DIFFS_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-url-of-the-page-comparing-this-page-content-with-the-previous-version"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        definitionTerms.put("[$NODE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-node-in-which-the-page-was-added"));
        definitionTerms.put("[$PAGE_CONTENT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-page-content"));
        definitionTerms.put("[$PAGE_DATE_UPDATE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-date-of-the-modifications"));
        definitionTerms.put("[$PAGE_DIFFS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-page-content-compared-with-the-previous-version-page-content"));
        definitionTerms.put("[$PAGE_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-page-id"));
        definitionTerms.put("[$PAGE_SUMMARY$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-summary-of-the-page-or-the-modifications"));
        definitionTerms.put("[$PAGE_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-page-title"));
        definitionTerms.put("[$PAGE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-page-url"));
        definitionTerms.put("[$PAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-page"));
        definitionTerms.put("[$PAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-page"));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)request));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-wiki"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                long classPK;
                DLFileEntry obj = null;
                if (entryClassName.equals(DLFileEntry.class.getName())) {
                    classPK = GetterUtil.getLong((String)document.get("classPK"));
                    WikiPageLocalServiceUtil.getPage((long)classPK);
                    obj = DLFileEntryLocalServiceUtil.getDLFileEntry((long)entryClassPK);
                } else if (entryClassName.equals(MBMessage.class.getName())) {
                    classPK = GetterUtil.getLong((String)document.get("classPK"));
                    WikiPageLocalServiceUtil.getPage((long)classPK);
                    obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                } else if (entryClassName.equals(WikiPage.class.getName())) {
                    obj = WikiPageLocalServiceUtil.getPage((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Wiki search index is stale and contains entry {className=" + entryClassName + ", classPK=" + entryClassPK + "}"));
            }
        }
        return entries;
    }

    public static WikiNode getFirstNode(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List<WikiNode> nodes = WikiNodeLocalServiceUtil.getNodes((long)groupId);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        WikiPortletInstanceSettings wikiPortletInstanceSettings = WikiPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        String[] visibleNodeNames = wikiPortletInstanceSettings.getVisibleNodes();
        nodes = WikiUtil.orderNodes(nodes, visibleNodeNames);
        Object[] hiddenNodes = wikiPortletInstanceSettings.getHiddenNodes();
        Arrays.sort(hiddenNodes);
        for (WikiNode node : nodes) {
            if (Arrays.binarySearch(hiddenNodes, node.getName()) >= 0 || !WikiNodePermission.contains(permissionChecker, node, "VIEW")) continue;
            return node;
        }
        return null;
    }

    public static String getFormattedContent(RenderRequest renderRequest, RenderResponse renderResponse, WikiPage wikiPage, PortletURL viewPageURL, PortletURL editPageURL, String title, boolean preview) throws Exception {
        WikiPageDisplay pageDisplay;
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
        PortletURL curViewPageURL = PortletURLUtil.clone((PortletURL)viewPageURL, (MimeResponse)renderResponse);
        PortletURL curEditPageURL = PortletURLUtil.clone((PortletURL)editPageURL, (MimeResponse)renderResponse);
        StringBundler sb = new StringBundler(8);
        sb.append(themeDisplay.getPathMain());
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(themeDisplay.getPlid());
        sb.append("&nodeId=");
        sb.append(wikiPage.getNodeId());
        sb.append("&title=");
        sb.append(HttpUtil.encodeURL((String)wikiPage.getTitle()));
        sb.append("&fileName=");
        String attachmentURLPrefix = sb.toString();
        if (!preview && version == 0.0 && (pageDisplay = WikiCacheUtil.getDisplay(wikiPage.getNodeId(), title, curViewPageURL, curEditPageURL, attachmentURLPrefix)) != null) {
            return pageDisplay.getFormattedContent();
        }
        return WikiUtil.convert(wikiPage, curViewPageURL, curEditPageURL, attachmentURLPrefix);
    }

    public static String getHelpPage(String format) {
        return _instance._getHelpPage(format);
    }

    public static String getHelpURL(String format) {
        return _instance._getHelpURL(format);
    }

    public static Map<String, Boolean> getLinks(WikiPage page) throws PageContentException {
        return _instance._getLinks(page);
    }

    public static List<String> getNodeNames(List<WikiNode> nodes) {
        ArrayList<String> nodeNames = new ArrayList<String>(nodes.size());
        for (WikiNode node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public static List<WikiNode> getNodes(List<WikiNode> nodes, String[] hiddenNodes, PermissionChecker permissionChecker) {
        nodes = ListUtil.copy(nodes);
        Arrays.sort(hiddenNodes);
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            WikiNode node = (WikiNode)itr.next();
            if (Arrays.binarySearch(hiddenNodes, node.getName()) < 0 && WikiNodePermission.contains(permissionChecker, node, "VIEW")) continue;
            itr.remove();
        }
        return nodes;
    }

    public static OrderByComparator<WikiPage> getPageOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        PageCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("modifiedDate")) {
            orderByComparator = new PageCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new PageTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new PageVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static List<WikiNode> orderNodes(List<WikiNode> nodes, String[] visibleNodeNames) {
        if (ArrayUtil.isEmpty((Object[])visibleNodeNames)) {
            return nodes;
        }
        nodes = ListUtil.copy(nodes);
        ArrayList<WikiNode> orderedNodes = new ArrayList<WikiNode>(nodes.size());
        block0: for (String visibleNodeName : visibleNodeNames) {
            for (WikiNode node : nodes) {
                if (!node.getName().equals(visibleNodeName)) continue;
                orderedNodes.add(node);
                nodes.remove(node);
                continue block0;
            }
        }
        orderedNodes.addAll(nodes);
        return orderedNodes;
    }

    public static String processContent(String content) {
        content = StringUtil.replace((String)content, (String)"</p>", (String)"</p>\n");
        content = StringUtil.replace((String)content, (String)"</br>", (String)"</br>\n");
        content = StringUtil.replace((String)content, (String)"</div>", (String)"</div>\n");
        return content;
    }

    public static String unescapeName(String name) {
        return StringUtil.replace((String)name, (String[])_ESCAPED_CHARS, (String[])_UNESCAPED_CHARS);
    }

    public static boolean validate(long nodeId, String content, String format) throws WikiFormatException {
        return _instance._validate(nodeId, content, format);
    }

    private String _convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        LiferayPortletURL liferayViewPageURL = (LiferayPortletURL)viewPageURL;
        LiferayPortletURL liferayEditPageURL = (LiferayPortletURL)editPageURL;
        WikiEngine engine = this._getEngine(page.getFormat());
        String content = engine.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        String editPageURLString = "";
        if (editPageURL != null) {
            liferayEditPageURL.setParameter("title", "__REPLACEMENT__", false);
            editPageURLString = editPageURL.toString();
            editPageURLString = StringUtil.replace((String)editPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        Matcher matcher = _editPageURLPattern.matcher(content);
        content = this._convertURLs(editPageURLString, matcher);
        String viewPageURLString = "";
        if (viewPageURL != null) {
            liferayViewPageURL.setParameter("title", "__REPLACEMENT__", false);
            viewPageURLString = viewPageURL.toString();
            viewPageURLString = StringUtil.replace((String)viewPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        matcher = _viewPageURLPattern.matcher(content);
        content = this._convertURLs(viewPageURLString, matcher);
        content = this._replaceAttachments(content, page.getTitle(), attachmentURLPrefix);
        return content;
    }

    private String _convertURLs(String url, Matcher matcher) {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = null;
            if (matcher.groupCount() >= 1) {
                String encodedTitle = HttpUtil.encodeURL((String)HtmlUtil.unescape((String)matcher.group(1)));
                replacement = url.replace("$1", encodedTitle);
            } else {
                replacement = url;
            }
            matcher.appendReplacement(sb, replacement);
        }
        return matcher.appendTail(sb).toString();
    }

    private String _getEditPage(String format) {
        return PropsUtil.get("wiki.formats.edit.page", new Filter(format));
    }

    private WikiEngine _getEngine(String format) throws WikiFormatException {
        WikiEngine engine = this._engines.get(format);
        if (engine != null) {
            return engine;
        }
        Map<String, WikiEngine> map = this._engines;
        synchronized (map) {
            engine = this._engines.get(format);
            if (engine != null) {
                return engine;
            }
            try {
                String engineClass = PropsUtil.get("wiki.formats.engine", new Filter(format));
                if (engineClass == null) {
                    throw new WikiFormatException(format);
                }
                if (!InstancePool.contains((String)engineClass)) {
                    engine = (WikiEngine)InstancePool.get((String)engineClass);
                    engine.setMainConfiguration(this._readConfigurationFile("wiki.formats.configuration.main", format));
                    engine.setInterWikiConfiguration(this._readConfigurationFile("wiki.formats.configuration.interwiki", format));
                } else {
                    engine = (WikiEngine)InstancePool.get((String)engineClass);
                }
                this._engines.put(format, engine);
                return engine;
            }
            catch (Exception e) {
                throw new WikiFormatException((Throwable)e);
            }
        }
    }

    private String _getHelpPage(String format) {
        return PropsUtil.get("wiki.formats.help.page", new Filter(format));
    }

    private String _getHelpURL(String format) {
        return PropsUtil.get("wiki.formats.help.url", new Filter(format));
    }

    private Map<String, Boolean> _getLinks(WikiPage page) throws PageContentException {
        try {
            return this._getEngine(page.getFormat()).getOutgoingLinks(page);
        }
        catch (WikiFormatException wfe) {
            return Collections.emptyMap();
        }
    }

    private String _readConfigurationFile(String propertyName, String format) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String configurationFile = PropsUtil.get(propertyName, new Filter(format));
        if (Validator.isNotNull((String)configurationFile)) {
            return HttpUtil.URLtoString((URL)classLoader.getResource(configurationFile));
        }
        return "";
    }

    private String _replaceAttachments(String content, String title, String attachmentURLPrefix) {
        content = StringUtil.replace((String)content, (String)"[$WIKI_PAGE_NAME$]", (String)title);
        content = StringUtil.replace((String)content, (String)"[$ATTACHMENT_URL_PREFIX$]", (String)attachmentURLPrefix);
        return content;
    }

    private boolean _validate(long nodeId, String content, String format) throws WikiFormatException {
        return this._getEngine(format).validate(nodeId, content);
    }
}

