/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class WikiPageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    public static final String PORTLET_ID = "36";

    public WikiPageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        long classPK = 0L;
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            classPK = dlFileEntry.getClassPK();
        } else if (obj instanceof MBMessage) {
            MBMessage message = (MBMessage)obj;
            classPK = message.getClassPK();
        }
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        catch (Exception e) {
            return;
        }
        document.addKeyword("nodeId", page.getNodeId());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)entryClassPK);
        return WikiPagePermission.contains(permissionChecker, page, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return this.isVisible(page.getStatus(), status);
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addStatus(contextQuery, searchContext);
        long[] nodeIds = searchContext.getNodeIds();
        if (ArrayUtil.isNotEmpty((long[])nodeIds)) {
            BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (long nodeId : nodeIds) {
                try {
                    WikiNodeServiceUtil.getNode((long)nodeId);
                }
                catch (Exception e) {
                    continue;
                }
                nodeIdsQuery.addTerm("nodeId", nodeId);
            }
            contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            long companyId = (Long)array[0];
            long nodeId = (Long)array[1];
            String title = (String)array[2];
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, nodeId, title);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)companyId, (String)document.get("uid"), (boolean)this.isCommitImmediately());
        } else if (obj instanceof WikiPage) {
            WikiPage page = (WikiPage)obj;
            this.deleteDocument(page.getCompanyId(), page.getPageId());
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)page);
        document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
        String content = HtmlUtil.extractText((String)WikiUtil.convert(page, null, null, null));
        document.addText("content", content);
        document.addKeyword("nodeId", page.getNodeId());
        document.addText("title", page.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        String nodeId = document.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", summary.getTitle());
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        if (!page.isHead() || !page.isApproved() && !page.isInTrash()) {
            return;
        }
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        Document document = this.getDocument(page);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK, (Boolean)null);
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexNodes(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = WikiNodeLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                WikiNode node = (WikiNode)object;
                WikiPageIndexer.this.reindexPages(companyId, node.getGroupId(), node.getNodeId());
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexPages(long companyId, long groupId, final long nodeId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = WikiPageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
                dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
                Property headProperty = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(headProperty.eq((Object)true));
            }
        });
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                WikiPage page = (WikiPage)object;
                Document document = WikiPageIndexer.this.getDocument(page);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

