/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.trash.RestoreEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.asset.WikiPageAssetRenderer;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.trash.BaseWikiTrashHandler;
import com.liferay.portlet.wiki.util.WikiPageAttachmentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class WikiPageTrashHandler
extends BaseWikiTrashHandler {
    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return super.addDeletionSystemEvent(userId, groupId, page.getPageId(), classUuid, referrerClassName);
    }

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        this.checkRestorableEntry(classPK, 0L, containerModelId, page.getTitle(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        WikiPageLocalServiceUtil.deletePage((WikiPage)page);
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return this.getParentContainerModel((TrashedModel)page);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) {
        WikiPage page = (WikiPage)trashedModel;
        if (Validator.isNotNull((String)page.getParentTitle())) {
            try {
                WikiPage parentPage = page.getParentPage();
                while (parentPage.isInTrashImplicitly()) {
                    parentPage = parentPage.getParentPage();
                }
                if (parentPage.isInTrashExplicitly()) {
                    return parentPage;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return page.getNode();
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        containerModels.add(this.getParentContainerModel(classPK));
        return containerModels;
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        WikiNode node = page.getNode();
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", HtmlUtil.unescape((String)page.getTitle()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        WikiNode node = page.getNode();
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        WikiNode node = page.getNode();
        return node.getName();
    }

    public String getTrashContainerModelName() {
        return "children-pages";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return WikiPageLocalServiceUtil.getChildrenCount((long)page.getNodeId(), (boolean)true, (String)page.getTitle(), (int)8);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        List pages = WikiPageLocalServiceUtil.getChildren((long)page.getNodeId(), (boolean)true, (String)page.getTitle(), (int)8);
        for (WikiPage curPage : pages) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)WikiPage.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curPage.getResourcePrimKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return page.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return new WikiPageAssetRenderer(page);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            WikiPage page = WikiPageLocalServiceUtil.fetchLatestPage((long)classPK, (int)-1, (boolean)true);
            if (page != null) {
                WikiPagePermission.check(permissionChecker, page.getNodeId(), page.getTitle(), "DELETE");
                classPK = page.getNodeId();
            }
            return WikiNodePermission.contains(permissionChecker, classPK, "ADD_PAGE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return page.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        return page.isInTrashContainer();
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isRootContainerModelMovable() {
        return true;
    }

    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException {
        if (!className.equals(DLFileEntry.class.getName())) {
            return;
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)classPK);
        WikiPage page = WikiPageAttachmentsUtil.getPage(classPK);
        WikiPageServiceUtil.restorePageAttachmentFromTrash((long)page.getNodeId(), (String)page.getTitle(), (String)fileEntry.getTitle());
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        WikiPageLocalServiceUtil.restorePageFromTrash((long)userId, (WikiPage)page);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        page.setTitle(name);
        WikiPageLocalServiceUtil.updateWikiPage((WikiPage)page);
        WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)page.getResourcePrimKey());
        pageResource.setTitle(name);
        WikiPageResourceLocalServiceUtil.updateWikiPageResource((WikiPageResource)pageResource);
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        WikiPageResource duplicatePageResource;
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        if (containerModelId == -1L) {
            containerModelId = page.getNodeId();
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicatePageResource = WikiPageResourceLocalServiceUtil.fetchPageResource((long)containerModelId, (String)originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            WikiPage duplicatePage = WikiPageLocalServiceUtil.getLatestPage((long)duplicatePageResource.getResourcePrimKey(), (int)-1, (boolean)false);
            ree.setDuplicateEntryId(duplicatePage.getResourcePrimKey());
            ree.setOldName(duplicatePage.getTitle());
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
        List pages = WikiPageLocalServiceUtil.getDependentPages((long)page.getNodeId(), (boolean)true, (String)page.getTitle(), (int)8);
        for (WikiPage curPage : pages) {
            this.checkRestorableEntry(curPage.getResourcePrimKey(), 0L, containerModelId, curPage.getTitle(), TrashUtil.getOriginalTitle((String)curPage.getTitle()));
        }
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean isContainerModel) throws PortalException {
        String portletId = "36";
        WikiPage page = WikiPageLocalServiceUtil.getLatestPage((long)classPK, (int)-1, (boolean)false);
        long plid = PortalUtil.getPlidFromPortletId((long)page.getGroupId(), (String)"36");
        if (plid == 0L) {
            portletId = "154";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (isContainerModel) {
            if (portletId.equals("36")) {
                portletURL.setParameter("struts_action", "/wiki/view_all_pages");
            } else {
                portletURL.setParameter("struts_action", "/wiki_admin/view_all_pages");
            }
        } else if (portletId.equals("36")) {
            portletURL.setParameter("struts_action", "/wiki/view");
        } else {
            portletURL.setParameter("struts_action", "/wiki_admin/view");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return WikiPagePermission.contains(permissionChecker, classPK, actionId);
    }
}

