/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class BaseWikiTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
        if (page == null) {
            return WikiNodeLocalServiceUtil.getNode((long)containerModelId);
        }
        return page;
    }

    public String getContainerModelClassName(long classPK) {
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        catch (Exception e) {
            page = WikiPageLocalServiceUtil.fetchWikiPage((long)classPK);
        }
        try {
            for (WikiPage parentPage = page.getParentPage(); parentPage != null; parentPage = parentPage.getParentPage()) {
                if (!parentPage.isInTrashExplicitly()) continue;
                return WikiPage.class.getName();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return WikiNode.class.getName();
    }

    public String getContainerModelName(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)classPK);
        if (page == null) {
            WikiNodeLocalServiceUtil.getNode((long)classPK);
            return "wiki-node";
        }
        return "wiki-page";
    }

    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        WikiPage page = null;
        String parentTitle = "";
        if (containerModelId > 0L) {
            page = WikiPageLocalServiceUtil.getPage((long)containerModelId);
            if (page == null) {
                List pages = WikiPageLocalServiceUtil.getPages((long)containerModelId, (int)start, (int)end);
                for (WikiPage curPage : pages) {
                    containerModels.add((ContainerModel)curPage);
                }
                return containerModels;
            }
            parentTitle = page.getTitle();
        } else {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        List pages = WikiPageLocalServiceUtil.getChildren((long)page.getNodeId(), (boolean)true, (String)parentTitle, (int)start, (int)end);
        for (WikiPage curPage : pages) {
            containerModels.add((ContainerModel)curPage);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException {
        WikiPage page = null;
        String parentTitle = "";
        if (containerModelId > 0L) {
            page = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
            if (page == null) {
                return WikiPageLocalServiceUtil.getPagesCount((long)containerModelId);
            }
            parentTitle = page.getTitle();
        } else {
            page = WikiPageLocalServiceUtil.getPage((long)classPK);
        }
        return WikiPageLocalServiceUtil.getChildrenCount((long)page.getNodeId(), (boolean)true, (String)parentTitle);
    }

    public long getDestinationContainerModelId(long classPK, long destinationContainerModelId) {
        WikiPage page;
        if (destinationContainerModelId == 0L && (page = WikiPageLocalServiceUtil.fetchPage((long)classPK)) != null) {
            return page.getNodeId();
        }
        return destinationContainerModelId;
    }

    public String getRootContainerModelClassName() {
        return WikiNode.class.getName();
    }

    public long getRootContainerModelId(long classPK) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.fetchLatestPage((long)classPK, (int)-1, (boolean)false);
        if (page == null) {
            WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
            return node.getNodeId();
        }
        return page.getNodeId();
    }

    public List<ContainerModel> getRootContainerModels(long groupId) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        List nodes = WikiNodeLocalServiceUtil.getNodes((long)groupId, (int)0);
        for (WikiNode node : nodes) {
            containerModels.add((ContainerModel)node);
        }
        return containerModels;
    }

    public int getRootContainerModelsCount(long groupId) {
        return WikiNodeLocalServiceUtil.getNodesCount((long)groupId);
    }

    public String getRootContainerModelTitle(long containerModelId, Locale locale) throws PortalException {
        WikiNode node = null;
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
        node = page == null ? WikiNodeLocalServiceUtil.getNode((long)containerModelId) : page.getNode();
        return TrashUtil.getOriginalTitle((String)node.getName());
    }

    public String getSubcontainerModelName() {
        return "wiki-page";
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this.moveTrashEntry(userId, classPK, containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        WikiPage parentPage = WikiPageLocalServiceUtil.fetchPage((long)containerModelId);
        if (parentPage == null) {
            WikiPageLocalServiceUtil.movePageFromTrash((long)userId, (long)page.getNodeId(), (String)page.getTitle(), (long)containerModelId, (String)"");
            return;
        }
        WikiPageLocalServiceUtil.movePageFromTrash((long)userId, (long)page.getNodeId(), (String)page.getTitle(), (long)parentPage.getNodeId(), (String)parentPage.getTitle());
    }
}

