/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.translators;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.wiki.translators.BaseTranslator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaWikiToCreoleTranslator
extends BaseTranslator {
    public static final String TABLE_OF_CONTENTS = "<<TableOfContents>>\n\n";
    private static final String[] _HTML_TAGS = new String[]{"<blockquote>", "</blockquote>", "<br>", "<br/>", "<br />", "<center>", "</center>", "<cite>", "</cite>", "<code>", "</code>", "</div>", "</font>", "<hr>", "<hr/>", "<hr />", "<p>", "</p>", "<tt>", "</tt>", "<var>", "</var>"};
    private Pattern[] _htmlTagPatterns = new Pattern[]{Pattern.compile("<div[^>]*>"), Pattern.compile("<font[^>]*>")};
    private Pattern _imagePattern = Pattern.compile("(\\[{2})(Image|File)(:)", 32);
    private Pattern _linkPattern = Pattern.compile("\\[{2}([^\\]]*)\\]{2}", 32);
    private Pattern _mediaWikiTablePattern1 = Pattern.compile("class=(.*?)[|\n\r]");
    private Pattern _mediaWikiTablePattern2 = Pattern.compile("(\\|\\-)(.*)");
    private Pattern _mediaWikiTablePattern3 = Pattern.compile("\\|\\+(.*)");
    private Pattern _mediaWikiTablePattern4 = Pattern.compile("(?m)^!(.+)");
    private boolean _strictImportMode;
    private Pattern _tablePattern = Pattern.compile("\\{\\|(.*?)\\|\\}", 32);
    private Pattern _titlePattern = Pattern.compile("^=([^=]+)=", 8);

    public MediaWikiToCreoleTranslator() {
        this.initRegexps();
        this.initNowikiRegexps();
    }

    public boolean isStrictImportMode() {
        return this._strictImportMode;
    }

    public void setStrictImportMode(boolean strictImportMode) {
        this._strictImportMode = strictImportMode;
    }

    protected void initNowikiRegexps() {
        this.nowikiRegexps.add("(<nowiki>)(.*?)(</nowiki>)");
        this.nowikiRegexps.add("(<pre>)(.*?)(</pre>)");
        this.nowikiRegexps.add("~(\\*\\*|~|//|-|#|\\{\\{|}}|\\\\|~\\[~~[|]]|----|=|\\|)");
    }

    protected void initRegexps() {
        this.regexps.put("= '''([^=]+)''' =", "= $1 =");
        this.regexps.put("== '''([^=]+)''' ==", "== $1 ==");
        this.regexps.put("== '''([^=]+)''' ===", "=== $1 ===");
        this.regexps.put("&lt;", "<");
        this.regexps.put("&gt;", ">");
        this.regexps.put("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*", "");
        this.regexps.put("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}", "");
        this.regexps.put("\\{{2}Work in progress\\}{2}", "");
        this.regexps.put("\\[{2}Wikipedia:([^\\]]*)\\]{2}", "");
        this.regexps.put("''''((?s:.)*?)(''''|(\n\n|\r\r|\r\n\r\n))", "**//$1//**$3");
        this.regexps.put("'''((?s:.)*?)('''|(\n\n|\r\r|\r\n\r\n))", "**$1**$3");
        this.regexps.put("''((?s:.)*?)(''|(\n\n|\r\r|\r\n\r\n))", "//$1//$3");
        this.regexps.put("\\[{2}((http|ftp)[^ ]*) ([^\\]]*)\\]{2}", "[$1 $3]");
        this.regexps.put("\\[((http|ftp)[^ ]*)\\]", "[[$1]]");
        this.regexps.put("\\[((http|ftp)[^ ]*) ([^\\]]*)\\]", "[[$1|$3]]");
        this.regexps.put("^\\t([\\w]+):\\t(.*)", "**$1**:\n$2");
        this.regexps.put("^\\t:\\t(.*)", "$1");
        this.regexps.put("(^ (.+))(\\n (.+))*", "{{{\n$0\n}}}");
        this.regexps.put("<nowiki>([^<]*)</nowiki>", "{{{$1}}}");
        this.regexps.put("<pre>([^<]*)</pre>", "{{{$1}}}");
        this.regexps.put("[-]*\\[{2}User:([^\\]]*)\\]{2}", "$1");
    }

    @Override
    protected String postProcess(String content) {
        if (this._strictImportMode) {
            content = this.runRegexp(content, "\\{{2}Special:(.*?)\\}{2}", "");
            content = this.runRegexp(content, "\\{{2}(.*?)\\}{2}", "");
            content = this.runRegexp(content, "(?s)\\{{2}(.*?)\\}{2}", "");
        } else {
            content = this.runRegexp(content, "\\{{2}Special:(.*?)\\}{2}", "{{{$1}}}\n");
            content = this.runRegexp(content, "\\{{2}(.*?)\\}{2}", "{{{$1}}}");
            content = this.runRegexp(content, "([^\\{])(\\{{2})([^\\{])", "$1\n{{{\n$3");
            content = this.runRegexp(content, "([^\\}])(\\}{2})([^\\}])", "$1\n}}}\n$3");
        }
        Matcher matcher = this._titlePattern.matcher(content);
        if (matcher.find()) {
            content = this.runRegexp(content, "^===([^=]+)===", "====$1====");
            content = this.runRegexp(content, "^==([^=]+)==", "===$1===");
            content = this.runRegexp(content, "^=([^=]+)=", "==$1==");
        }
        for (Pattern pattern : this._htmlTagPatterns) {
            matcher = pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        for (String htmlTag : _HTML_TAGS) {
            content = StringUtil.replace((String)content, (String)htmlTag, (String)"");
        }
        matcher = this._imagePattern.matcher(content);
        StringBuffer sb = new StringBuffer(content);
        int level = 0;
        int offset = 0;
        int originalLength = 0;
        int prefixLength = 0;
        while (matcher.find()) {
            level = 0;
            prefixLength = matcher.end(2) - matcher.start(2);
            for (int i = matcher.start(0) + offset; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) == '[' && sb.charAt(i + 1) == '[') {
                    ++level;
                    continue;
                }
                if (sb.charAt(i) != ']' || sb.charAt(i + 1) != ']' || --level != 0) continue;
                originalLength = i + 2 - (matcher.start(0) + offset);
                break;
            }
            int imageStartPos = matcher.end(3) + offset;
            int imageEndPos = matcher.start(2) + offset + originalLength - 4;
            String image = "{{SharedImages/" + StringUtil.toLowerCase((String)sb.substring(imageStartPos, imageEndPos)) + "}}";
            int imageLength = image.length();
            image = StringUtil.replace((String)image, (String)"[[", (String)"");
            image = StringUtil.replace((String)image, (String)"]]", (String)"");
            sb.replace(matcher.start(0) + offset, matcher.start(0) + originalLength + offset, image);
            offset += "SharedImages".length() - prefixLength - (imageLength - image.length());
        }
        content = sb.toString();
        matcher = this._tablePattern.matcher(content);
        sb = new StringBuffer(content);
        String mediaWikiTable = null;
        offset = 0;
        originalLength = 0;
        while (matcher.find()) {
            mediaWikiTable = sb.substring(matcher.start(1) + offset, matcher.end(1) + offset);
            originalLength = mediaWikiTable.length() + 4;
            Matcher matcher1 = this._mediaWikiTablePattern1.matcher(mediaWikiTable);
            mediaWikiTable = matcher1.replaceAll("");
            Matcher matcher2 = this._mediaWikiTablePattern2.matcher(mediaWikiTable);
            mediaWikiTable = matcher2.replaceAll("$1");
            Matcher matcher3 = this._mediaWikiTablePattern3.matcher(mediaWikiTable);
            mediaWikiTable = matcher3.replaceAll("===$1===");
            Matcher matcher4 = this._mediaWikiTablePattern4.matcher(mediaWikiTable);
            mediaWikiTable = matcher4.replaceAll("|=$1|");
            mediaWikiTable = StringUtil.replace((String)mediaWikiTable, (char)'\n', (String)"");
            mediaWikiTable = StringUtil.replace((String)mediaWikiTable, (char)'\r', (String)"");
            mediaWikiTable = StringUtil.replace((String)mediaWikiTable, (String)"|-", (String)"\n\r");
            mediaWikiTable = StringUtil.replace((String)mediaWikiTable, (String)"||", (String)"|");
            mediaWikiTable = StringUtil.replace((String)mediaWikiTable, (String)"////", (String)"");
            sb.replace(matcher.start(0) + offset, matcher.start(0) + originalLength + offset, mediaWikiTable);
            offset += mediaWikiTable.length() - originalLength;
        }
        content = sb.toString();
        content = this.runRegexp(content, "/{2}(\\{{3})", "$1");
        content = this.runRegexp(content, "(\\}{3})/{2}", "$1");
        matcher = this._linkPattern.matcher(content);
        sb = new StringBuffer(content);
        while (matcher.find()) {
            String link = matcher.group(1).replace("_", " ");
            sb.replace(matcher.start(1), matcher.end(1), link);
        }
        return TABLE_OF_CONTENTS + super.postProcess(sb.toString());
    }
}

