/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.persistence.WikiPageFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class WikiPageFinderImpl
extends BasePersistenceImpl<WikiPage>
implements WikiPageFinder {
    public static final String COUNT_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".countByCreateDate";
    public static final String FIND_BY_RESOURCE_PRIM_KEY = WikiPageFinder.class.getName() + ".findByResourcePrimKey";
    public static final String FIND_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".findByCreateDate";
    public static final String FIND_BY_NO_ASSETS = WikiPageFinder.class.getName() + ".findByNoAssets";

    public int countByCreateDate(long groupId, long nodeId, Date createDate, boolean before) {
        return this.countByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before);
    }

    public int countByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, createDate, before, false);
    }

    public int filterCountByCreateDate(long groupId, long nodeId, Date createDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, true);
    }

    public int filterCountByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, createDate, before, true);
    }

    public List<WikiPage> filterFindByCreateDate(long groupId, long nodeId, Date createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, start, end, true);
    }

    public List<WikiPage> filterFindByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, createDate, before, start, end, true);
    }

    public WikiPage findByResourcePrimKey(long resourcePrimKey) throws NoSuchPageException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_RESOURCE_PRIM_KEY);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(resourcePrimKey);
            List pages = q.list();
            if (!pages.isEmpty()) {
                WikiPage wikiPage = (WikiPage)pages.get(0);
                return wikiPage;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(3);
        sb.append("No WikiPage exists with the key {resourcePrimKey");
        sb.append(resourcePrimKey);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public List<WikiPage> findByCreateDate(long groupId, long nodeId, Date createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, start, end, false);
    }

    public List<WikiPage> findByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, createDate, before, start, end, false);
    }

    public List<WikiPage> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_CREATE_DATE);
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)WikiPage.class.getName(), (String)"WikiPage.resourcePrimKey", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(nodeId);
            qPos.add(createDate);
            qPos.add(true);
            qPos.add(0);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<WikiPage> doFindByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_CREATE_DATE);
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)WikiPage.class.getName(), (String)"WikiPage.resourcePrimKey", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(nodeId);
            qPos.add(createDate);
            qPos.add(true);
            qPos.add(0);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

