/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.wiki.model.WikiPage"})
public class WikiPagePermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, version, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiPage page, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, page, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)resourcePrimKey, (Boolean)null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageResourceException nspre) {
            return false;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException nspe) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException nspe) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getPageId(), (String)"36", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (page.isDraft()) {
            if (actionId.equals("VIEW") && !WikiPagePermission.contains(permissionChecker, page, "UPDATE")) {
                return false;
            }
            if (actionId.equals("DELETE") && page.getStatusByUserId() == permissionChecker.getUserId()) {
                return true;
            }
        } else if (page.isPending()) {
            hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)actionId);
            if (hasPermission != null && hasPermission.booleanValue()) {
                return true;
            }
        } else if (page.isScheduled() && actionId.equals("VIEW") && !WikiPagePermission.contains(permissionChecker, page, "UPDATE")) {
            return false;
        }
        if (actionId.equals("VIEW")) {
            WikiPage redirectPage = page.fetchRedirectPage();
            if (redirectPage != null) {
                page = redirectPage;
            }
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                WikiNode node = page.getNode();
                if (!WikiNodePermission.contains(permissionChecker, node, actionId)) {
                    return false;
                }
                while (page != null) {
                    if (!WikiPagePermission._hasPermission(permissionChecker, page, actionId)) {
                        return false;
                    }
                    page = page.fetchParentPage();
                }
                return true;
            }
        }
        return WikiPagePermission._hasPermission(permissionChecker, page, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        WikiPagePermission.check(permissionChecker, primaryKey, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        return permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), actionId) || permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
    }
}

