/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.wiki.model.WikiNode"})
public class WikiNodePermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long nodeId, String actionId) throws PortalException {
        if (!WikiNodePermission.contains(permissionChecker, nodeId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String name, String actionId) throws PortalException {
        if (!WikiNodePermission.contains(permissionChecker, groupId, name, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiNode node, String actionId) throws PortalException {
        if (!WikiNodePermission.contains(permissionChecker, node, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String actionId) throws PortalException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)nodeId);
        return WikiNodePermission.contains(permissionChecker, node, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String name, String actionId) throws PortalException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)groupId, (String)name);
        return WikiNodePermission.contains(permissionChecker, node, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, WikiNode node, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)node.getGroupId(), (String)WikiNode.class.getName(), (long)node.getNodeId(), (String)"36", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId(), node.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        WikiNodePermission.check(permissionChecker, primaryKey, actionId);
    }
}

