/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.DuplicatePageException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NodeChangeException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.PageTitleException;
import com.liferay.portlet.wiki.PageVersionException;
import com.liferay.portlet.wiki.WikiSettings;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiPageDisplayImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.base.WikiPageLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class WikiPageLocalServiceImpl
extends WikiPageLocalServiceBaseImpl {
    public WikiPage addPage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, boolean head, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        Date now = new Date();
        long pageId = this.counterLocalService.increment();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)node.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        this.validate(title, nodeId, content, format);
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        WikiPage page = this.wikiPagePersistence.create(pageId);
        page.setUuid(serviceContext.getUuid());
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(node.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(serviceContext.getCreateDate(now));
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(version);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(head);
        page.setParentTitle(parentTitle);
        page.setRedirectTitle(redirectTitle);
        page.setStatus(2);
        page.setStatusByUserId(userId);
        page.setStatusDate(serviceContext.getModifiedDate(now));
        page.setExpandoBridgeAttributes(serviceContext);
        this.wikiPagePersistence.update((BaseModel)page);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addPageResources(page, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addPageResources(page, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, page.getUserName(), page.getGroupId(), WikiPage.class.getName(), resourcePrimKey, 1);
        }
        this.startWorkflowInstance(userId, page, serviceContext);
        return page;
    }

    public WikiPage addPage(long userId, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException {
        double version = 1.0;
        String format = WikiPageConstants.DEFAULT_FORMAT;
        boolean head = false;
        String parentTitle = null;
        String redirectTitle = null;
        return this.addPage(userId, nodeId, title, version, content, summary, minorEdit, format, head, parentTitle, redirectTitle, serviceContext);
    }

    public void addPageAttachment(long userId, long nodeId, String title, String fileName, File file, String mimeType) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        Folder folder = page.addAttachmentsFolder();
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)"36", (long)folder.getFolderId(), (File)file, (String)fileName, (String)mimeType, (boolean)true);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        extraDataJSONObject.put("fileEntryTitle", fileEntry.getTitle());
        extraDataJSONObject.put("title", page.getTitle());
        extraDataJSONObject.put("version", page.getVersion());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10006, extraDataJSONObject.toString(), 0L);
    }

    public void addPageAttachment(long userId, long nodeId, String title, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        Folder folder = page.addAttachmentsFolder();
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)"36", (long)folder.getFolderId(), (InputStream)inputStream, (String)fileName, (String)mimeType, (boolean)true);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        extraDataJSONObject.put("fileEntryTitle", fileEntry.getTitle());
        extraDataJSONObject.put("title", page.getTitle());
        extraDataJSONObject.put("version", page.getVersion());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10006, extraDataJSONObject.toString(), 0L);
    }

    public void addPageAttachments(long userId, long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        if (inputStreamOVPs.isEmpty()) {
            return;
        }
        for (int i = 0; i < inputStreamOVPs.size(); ++i) {
            ObjectValuePair<String, InputStream> inputStreamOVP = inputStreamOVPs.get(i);
            String fileName = (String)inputStreamOVP.getKey();
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            File file = null;
            try {
                file = FileUtil.createTempFile((InputStream)inputStream);
                String mimeType = MimeTypesUtil.getContentType((File)file, (String)fileName);
                this.addPageAttachment(userId, nodeId, title, fileName, file, mimeType);
                continue;
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            finally {
                FileUtil.delete((File)file);
            }
        }
    }

    public void addPageResources(long nodeId, String title, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, addGroupPermissions, addGuestPermissions);
    }

    public void addPageResources(long nodeId, String title, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, groupPermissions, guestPermissions);
    }

    public void addPageResources(WikiPage page, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addPageResources(WikiPage page, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addTempFileEntry(long groupId, long userId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    @Deprecated
    public void addTempPageAttachment(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        this.addTempFileEntry(groupId, userId, tempFolderName, fileName, inputStream, mimeType);
    }

    public void changeNode(long userId, long nodeId, String title, long newNodeId, ServiceContext serviceContext) throws PortalException {
        if (nodeId == newNodeId) {
            return;
        }
        this.checkNodeChange(nodeId, title, newNodeId);
        WikiPage oldPage = this.getPage(nodeId, title);
        oldPage.setParentTitle("");
        serviceContext.setCommand("move");
        this.updatePage(userId, oldPage, newNodeId, oldPage.getTitle(), oldPage.getContent(), oldPage.getSummary(), oldPage.getMinorEdit(), oldPage.getFormat(), oldPage.getParentTitle(), oldPage.getRedirectTitle(), serviceContext);
    }

    public WikiPage changeParent(long userId, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        WikiPage parentPage;
        if (Validator.isNotNull((String)newParentTitle) && Validator.isNotNull((String)(parentPage = this.getPage(nodeId, newParentTitle)).getRedirectTitle())) {
            newParentTitle = parentPage.getRedirectTitle();
        }
        WikiPage page = this.getPage(nodeId, title);
        String originalParentTitle = page.getParentTitle();
        double version = page.getVersion();
        String content = page.getContent();
        String summary = serviceContext.translate("changed-parent-from-x", new Object[]{originalParentTitle});
        boolean minorEdit = false;
        String format = page.getFormat();
        String redirectTitle = page.getRedirectTitle();
        this.populateServiceContext(serviceContext, page);
        page = this.updatePage(userId, nodeId, title, version, content, summary, minorEdit, format, newParentTitle, redirectTitle, serviceContext);
        List oldPages = this.wikiPagePersistence.findByN_T_H(nodeId, title, false);
        for (WikiPage oldPage : oldPages) {
            if (WorkflowThreadLocal.isEnabled()) continue;
            oldPage.setParentTitle(originalParentTitle);
            this.wikiPagePersistence.update((BaseModel)oldPage);
        }
        return page;
    }

    public void copyPageAttachments(long userId, long templateNodeId, String templateTitle, long nodeId, String title) throws PortalException {
        WikiPage templatePage = this.getPage(templateNodeId, templateTitle);
        List templateFileEntries = templatePage.getAttachmentsFileEntries();
        for (FileEntry templateFileEntry : templateFileEntries) {
            this.addPageAttachment(userId, nodeId, title, templateFileEntry.getTitle(), templateFileEntry.getContentStream(), templateFileEntry.getMimeType());
        }
    }

    public void deletePage(long nodeId, String title) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            this.wikiPageLocalService.deletePage((WikiPage)pages.get(0));
        }
    }

    @Deprecated
    public void deletePage(long nodeId, String title, double version) throws PortalException {
        this.discardDraft(nodeId, title, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemEvent(action=1, send=false, type=1)
    public void deletePage(WikiPage page) throws PortalException {
        long folderId;
        List childPages = this.wikiPagePersistence.findByN_P(page.getNodeId(), page.getTitle());
        for (WikiPage childPage : childPages) {
            if (childPage.isApproved() || childPage.isInTrashImplicitly()) {
                this.wikiPageLocalService.deletePage(childPage);
                continue;
            }
            childPage.setParentTitle("");
            this.wikiPagePersistence.update((BaseModel)childPage);
        }
        List redirectPages = this.wikiPagePersistence.findByN_R(page.getNodeId(), page.getTitle());
        for (WikiPage redirectPage : redirectPages) {
            if (redirectPage.isApproved() || redirectPage.isInTrashImplicitly()) {
                this.wikiPageLocalService.deletePage(redirectPage);
                continue;
            }
            redirectPage.setRedirectTitle("");
            this.wikiPagePersistence.update((BaseModel)redirectPage);
        }
        List versionPages = this.wikiPagePersistence.findByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_R(page.getNodeId(), page.getTitle());
        this.resourceLocalService.deleteResource(page.getCompanyId(), WikiPage.class.getName(), 4, page.getResourcePrimKey());
        WikiPageResource pageResource = this.wikiPageResourceLocalService.fetchPageResource(page.getNodeId(), page.getTitle());
        if (pageResource != null) {
            this.wikiPageResourceLocalService.deleteWikiPageResource(pageResource);
        }
        if ((folderId = page.getAttachmentsFolderId()) != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        this.subscriptionLocalService.deleteSubscriptions(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey());
        SystemEventHierarchyEntryThreadLocal.pop((Class)page.getModelClass(), (long)page.getPageId());
        try {
            for (WikiPage versionPage : versionPages) {
                this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), versionPage.getPrimaryKey());
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.push((Class)page.getModelClass(), (long)page.getPageId());
        }
        this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this.expandoRowLocalService.deleteRows(page.getPrimaryKey());
        this.mbMessageLocalService.deleteDiscussionMessages(WikiPage.class.getName(), page.getResourcePrimKey());
        if (page.isInTrash()) {
            if (page.isInTrashExplicitly()) {
                page.setTitle(TrashUtil.getOriginalTitle((String)page.getTitle()));
                this.trashEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
            } else {
                for (WikiPage versionPage : versionPages) {
                    this.trashVersionLocalService.deleteTrashVersion(WikiPage.class.getName(), versionPage.getPageId());
                }
            }
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.delete((Object)page);
        this.clearPageCache(page);
        for (WikiPage versionPage : versionPages) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(versionPage.getCompanyId(), versionPage.getGroupId(), WikiPage.class.getName(), versionPage.getPageId());
        }
        if (pageResource != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("version", page.getVersion());
            this.systemEventLocalService.addSystemEvent(0L, page.getGroupId(), page.getModelClassName(), page.getPrimaryKey(), pageResource.getUuid(), null, 1, extraDataJSONObject.toString());
        }
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)page.getGroupId(), (long)folderId, (String)fileName);
        this.deletePageAttachment(fileEntry.getFileEntryId());
    }

    public void deletePageAttachments(long nodeId, String title) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntries((long)page.getGroupId(), (long)folderId);
    }

    public void deletePages(long nodeId) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_H_P(nodeId, true, "");
        for (WikiPage page : pages) {
            this.wikiPageLocalService.deletePage(page);
        }
        pages = this.wikiPagePersistence.findByN_H_P(nodeId, false, "");
        for (WikiPage page : pages) {
            this.wikiPageLocalService.deletePage(page);
        }
    }

    public void deleteTempFileEntry(long groupId, long userId, String folderName, String fileName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName);
    }

    public void deleteTrashPageAttachments(long nodeId, String title) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntries((long)page.getGroupId(), (long)folderId, (int)8);
    }

    public void discardDraft(long nodeId, String title, double version) throws PortalException {
        this.wikiPagePersistence.removeByN_T_V(nodeId, title, version);
    }

    public WikiPage fetchLatestPage(long resourcePrimKey, int status, boolean preferApproved) {
        WikiPage page = null;
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                page = this.wikiPagePersistence.fetchByR_S_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (page == null) {
                page = this.wikiPagePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            page = this.wikiPagePersistence.fetchByR_S_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return page;
    }

    public WikiPage fetchLatestPage(long resourcePrimKey, long nodeId, int status, boolean preferApproved) {
        WikiPage page = null;
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                page = this.wikiPagePersistence.fetchByR_N_S_First(resourcePrimKey, nodeId, 0, (OrderByComparator)orderByComparator);
            }
            if (page == null) {
                page = this.wikiPagePersistence.fetchByR_N_First(resourcePrimKey, nodeId, (OrderByComparator)orderByComparator);
            }
        } else {
            page = this.wikiPagePersistence.fetchByR_N_S_First(resourcePrimKey, nodeId, status, (OrderByComparator)orderByComparator);
        }
        return page;
    }

    public WikiPage fetchLatestPage(long nodeId, String title, int status, boolean preferApproved) {
        WikiPage page = null;
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                page = this.wikiPagePersistence.fetchByN_T_S_First(nodeId, title, 0, (OrderByComparator)orderByComparator);
            }
            if (page == null) {
                page = this.wikiPagePersistence.fetchByN_T_First(nodeId, title, (OrderByComparator)orderByComparator);
            }
        } else {
            page = this.wikiPagePersistence.fetchByN_T_S_First(nodeId, title, status, (OrderByComparator)orderByComparator);
        }
        return page;
    }

    public WikiPage fetchPage(long resourcePrimKey) {
        WikiPageResource pageResource = this.wikiPageResourceLocalService.fetchWikiPageResource(resourcePrimKey);
        if (pageResource == null) {
            return null;
        }
        return this.fetchPage(pageResource.getNodeId(), pageResource.getTitle());
    }

    public WikiPage fetchPage(long nodeId, String title) {
        return this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title, true, null);
    }

    public WikiPage fetchPage(long nodeId, String title, double version) {
        WikiPage page = null;
        page = version == 0.0 ? this.fetchPage(nodeId, title) : this.wikiPagePersistence.fetchByN_T_V(nodeId, title, version);
        return page;
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle) {
        return this.getChildren(nodeId, head, parentTitle, 0);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle, int status) {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head, parentTitle, status);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle, int start, int end) {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head, parentTitle, 0, start, end);
    }

    public int getChildrenCount(long nodeId, boolean head, String parentTitle) {
        return this.getChildrenCount(nodeId, head, parentTitle, 0);
    }

    public int getChildrenCount(long nodeId, boolean head, String parentTitle, int status) {
        return this.wikiPagePersistence.countByN_H_P_S(nodeId, head, parentTitle, status);
    }

    public List<WikiPage> getDependentPages(long nodeId, boolean head, String title, int status) {
        ArrayList<WikiPage> dependentPages = new ArrayList<WikiPage>();
        List<WikiPage> childPages = this.getChildren(nodeId, head, title, status);
        dependentPages.addAll(childPages);
        List<WikiPage> redirectPages = this.getRedirectPages(nodeId, head, title, status);
        dependentPages.addAll(redirectPages);
        return dependentPages;
    }

    public WikiPage getDraftPage(long nodeId, String title) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 2, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 1, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public List<WikiPage> getIncomingLinks(long nodeId, String title) throws PortalException {
        HashSet<WikiPage> links = new HashSet<WikiPage>();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this.isLinkedTo(page, title)) continue;
            links.add(page);
        }
        List referrals = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage referral : referrals) {
            for (WikiPage page : pages) {
                if (!this.isLinkedTo(page, referral.getTitle())) continue;
                links.add(page);
            }
        }
        return ListUtil.sort(new ArrayList(links));
    }

    public WikiPage getLatestPage(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(resourcePrimKey, status, preferApproved);
        if (page == null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{resourcePrimKey=");
            sb.append(resourcePrimKey);
            sb.append(", status=");
            sb.append(status);
            sb.append("}");
            throw new NoSuchPageException(sb.toString());
        }
        return page;
    }

    public WikiPage getLatestPage(long resourcePrimKey, long nodeId, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(resourcePrimKey, nodeId, status, preferApproved);
        if (page == null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{resourcePrimKey=");
            sb.append(resourcePrimKey);
            sb.append(", nodeId=");
            sb.append(nodeId);
            sb.append(", status=");
            sb.append(status);
            sb.append("}");
            throw new NoSuchPageException(sb.toString());
        }
        return page;
    }

    public WikiPage getLatestPage(long nodeId, String title, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(nodeId, title, status, preferApproved);
        if (page == null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{nodeId=");
            sb.append(nodeId);
            sb.append(", title=");
            sb.append(title);
            sb.append(", status=");
            sb.append(status);
            sb.append("}");
            throw new NoSuchPageException(sb.toString());
        }
        return page;
    }

    public List<WikiPage> getNoAssetPages() {
        return this.wikiPageFinder.findByNoAssets();
    }

    public List<WikiPage> getOrphans(long nodeId) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_H_S(nodeId, true, 0);
        return WikiUtil.filterOrphans(pages);
    }

    public List<WikiPage> getOutgoingLinks(long nodeId, String title) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        LinkedHashMap<String, WikiPage> pages = new LinkedHashMap<String, WikiPage>();
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        for (Map.Entry<String, Boolean> entry : links.entrySet()) {
            String curTitle = entry.getKey();
            Boolean exists = entry.getValue();
            if (exists.booleanValue()) {
                WikiPage curPage = this.getPage(nodeId, curTitle);
                if (pages.containsKey(curPage.getTitle())) continue;
                pages.put(curPage.getTitle(), curPage);
                continue;
            }
            WikiPageImpl newPage = new WikiPageImpl();
            newPage.setNew(true);
            newPage.setNodeId(nodeId);
            newPage.setTitle(curTitle);
            if (pages.containsKey(curTitle)) continue;
            pages.put(curTitle, newPage);
        }
        return ListUtil.fromMapValues(pages);
    }

    public WikiPage getPage(long resourcePrimKey) throws PortalException {
        return this.getPage(resourcePrimKey, Boolean.TRUE);
    }

    public WikiPage getPage(long resourcePrimKey, Boolean head) throws PortalException {
        WikiPageResource pageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        return this.getPage(pageResource.getNodeId(), pageResource.getTitle(), head);
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException {
        WikiPage page = this.fetchPage(nodeId, title);
        if (page != null) {
            return page;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getPage(long nodeId, String title, Boolean head) throws PortalException {
        List pages = head == null ? this.wikiPagePersistence.findByN_T(nodeId, title, 0, 1) : this.wikiPagePersistence.findByN_T_H(nodeId, title, head.booleanValue(), 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        StringBundler sb = new StringBundler(7);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title);
        sb.append(", head=");
        sb.append((Object)head);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException {
        WikiPage page = null;
        page = version == 0.0 ? this.getPage(nodeId, title) : this.wikiPagePersistence.findByN_T_V(nodeId, title, version);
        return page;
    }

    public WikiPage getPageByPageId(long pageId) throws PortalException {
        return this.wikiPagePersistence.findByPrimaryKey(pageId);
    }

    public WikiPageDisplay getPageDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        return this.getPageDisplay(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException {
        String formattedContent = WikiUtil.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        return new WikiPageDisplayImpl(page.getUserId(), page.getNodeId(), page.getTitle(), page.getVersion(), page.getContent(), formattedContent, page.getFormat(), page.getHead(), page.getAttachmentsFileEntries());
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end) {
        return this.getPages(nodeId, head, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int status, int start, int end) {
        return this.getPages(nodeId, head, status, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int status, int start, int end, OrderByComparator<WikiPage> obc) {
        if (status == -1) {
            return this.wikiPagePersistence.findByN_H(nodeId, head, start, end, obc);
        }
        return this.wikiPagePersistence.findByN_H_S(nodeId, head, status, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.getPages(nodeId, head, 0, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, int start, int end) {
        return this.getPages(nodeId, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.wikiPagePersistence.findByNodeId(nodeId, start, end, obc);
    }

    public List<WikiPage> getPages(long resourcePrimKey, long nodeId, int status) {
        return this.wikiPagePersistence.findByR_N_S(resourcePrimKey, nodeId, status);
    }

    public List<WikiPage> getPages(long userId, long nodeId, int status, int start, int end) {
        if (userId > 0L) {
            return this.wikiPagePersistence.findByU_N_S(userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.findByN_S(nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, boolean head, int start, int end) {
        return this.wikiPagePersistence.findByN_T_H(nodeId, title, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end) {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, obc);
    }

    public List<WikiPage> getPages(String format) {
        return this.wikiPagePersistence.findByFormat(format);
    }

    public int getPagesCount(long nodeId) {
        return this.wikiPagePersistence.countByNodeId(nodeId);
    }

    public int getPagesCount(long nodeId, boolean head) {
        return this.wikiPagePersistence.countByN_H_S(nodeId, head, 0);
    }

    public int getPagesCount(long nodeId, boolean head, int status) {
        if (status == -1) {
            return this.wikiPagePersistence.countByN_H_NotS(nodeId, head, 8);
        }
        return this.wikiPagePersistence.countByN_H_S(nodeId, head, status);
    }

    public int getPagesCount(long nodeId, int status) {
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long userId, long nodeId, int status) {
        if (userId > 0L) {
            return this.wikiPagePersistence.countByU_N_S(userId, nodeId, status);
        }
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long nodeId, String title) {
        return this.wikiPagePersistence.countByN_T(nodeId, title);
    }

    public int getPagesCount(long nodeId, String title, boolean head) {
        return this.wikiPagePersistence.countByN_T_H(nodeId, title, head);
    }

    public int getPagesCount(String format) {
        return this.wikiPagePersistence.countByFormat(format);
    }

    public WikiPage getPreviousVersionPage(WikiPage page) throws PortalException {
        double previousVersion = MathUtil.format((double)(page.getVersion() - 0.1), (int)1, (int)1);
        if (previousVersion < 1.0) {
            return null;
        }
        return this.getPage(page.getNodeId(), page.getTitle(), previousVersion);
    }

    @Deprecated
    public List<WikiPage> getRecentChanges(long nodeId, int start, int end) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.getRecentChanges(node.getGroupId(), nodeId, start, end);
    }

    public List<WikiPage> getRecentChanges(long groupId, long nodeId, int start, int end) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.findByCreateDate(groupId, nodeId, cal.getTime(), false, start, end);
    }

    @Deprecated
    public int getRecentChangesCount(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.getRecentChangesCount(node.getGroupId(), nodeId);
    }

    public int getRecentChangesCount(long groupId, long nodeId) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.countByCreateDate(groupId, nodeId, cal.getTime(), false);
    }

    public List<WikiPage> getRedirectPages(long nodeId, boolean head, String redirectTitle, int status) {
        return this.wikiPagePersistence.findByN_H_R_S(nodeId, head, redirectTitle, status);
    }

    public String[] getTempFileNames(long groupId, long userId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public boolean hasDraftPage(long nodeId, String title) {
        int count = this.wikiPagePersistence.countByN_T_S(nodeId, title, 2);
        return count > 0;
    }

    public void moveDependentToTrash(WikiPage page, long trashEntryId) throws PortalException {
        this.moveDependentToTrash(page, trashEntryId, false);
    }

    @Deprecated
    public void movePage(long userId, long nodeId, String title, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException {
        this.renamePage(userId, nodeId, title, newTitle, strict, serviceContext);
    }

    @Deprecated
    public void movePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException {
        this.renamePage(userId, nodeId, title, newTitle, true, serviceContext);
    }

    public FileEntry movePageAttachmentToTrash(long userId, long nodeId, String title, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)page.getGroupId(), (long)page.getAttachmentsFolderId(), (String)fileName);
        fileEntry = PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)userId, (long)fileEntry.getFileEntryId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        extraDataJSONObject.put("fileEntryTitle", TrashUtil.getOriginalTitle((String)fileEntry.getTitle()));
        extraDataJSONObject.put("title", page.getTitle());
        extraDataJSONObject.put("version", page.getVersion());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10009, extraDataJSONObject.toString(), 0L);
        return fileEntry;
    }

    public WikiPage movePageFromTrash(long userId, long nodeId, String title, long newNodeId, String newParentTitle) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        if (page.isInTrashExplicitly()) {
            this.movePageFromTrash(userId, page, newNodeId, newParentTitle);
        } else {
            this.moveDependentFromTrash(page, newNodeId, newParentTitle);
        }
        return page;
    }

    @Deprecated
    public WikiPage movePageFromTrash(long userId, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        return this.movePageFromTrash(userId, nodeId, title, nodeId, newParentTitle);
    }

    public WikiPage movePageToTrash(long userId, long nodeId, String title) throws PortalException {
        List wikiPages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!wikiPages.isEmpty()) {
            return this.movePageToTrash(userId, (WikiPage)wikiPages.get(0));
        }
        return null;
    }

    public WikiPage movePageToTrash(long userId, long nodeId, String title, double version) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_V(nodeId, title, version);
        return this.movePageToTrash(userId, page);
    }

    public WikiPage movePageToTrash(long userId, WikiPage page) throws PortalException {
        int oldStatus = page.getStatus();
        String oldTitle = page.getTitle();
        if (oldStatus == 1) {
            page.setStatus(2);
            this.wikiPagePersistence.update((BaseModel)page);
        }
        List pageVersions = this.wikiPagePersistence.findByR_N_H(page.getResourcePrimKey(), page.getNodeId(), false);
        pageVersions = ListUtil.sort((List)pageVersions, (Comparator)new PageVersionComparator());
        List<Object> pageVersionStatusOVPs = new ArrayList();
        if (pageVersions != null && !pageVersions.isEmpty()) {
            pageVersionStatusOVPs = this.getPageVersionStatuses(pageVersions);
        }
        page = this.updateStatus(userId, page, 8, new ServiceContext(), new HashMap<String, Serializable>());
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByPrimaryKey(page.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", page.getTitle());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), pageResource.getUuid(), null, oldStatus, pageVersionStatusOVPs, typeSettingsProperties);
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        for (WikiPage pageVersion : pageVersions) {
            pageVersion.setTitle(trashTitle);
            pageVersion.setStatus(8);
            this.wikiPagePersistence.update((BaseModel)pageVersion);
        }
        pageResource.setTitle(trashTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setTitle(trashTitle);
        this.wikiPagePersistence.update((BaseModel)page);
        this.moveDependentChildPagesToTrash(page, oldTitle, trashTitle, trashEntry.getEntryId(), true);
        this.moveDependentRedirectPagesToTrash(page, oldTitle, trashTitle, trashEntry.getEntryId(), true);
        this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", TrashUtil.getOriginalTitle((String)page.getTitle()));
        extraDataJSONObject.put("version", page.getVersion());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10007, extraDataJSONObject.toString(), 0L);
        if (!pageVersions.isEmpty()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            for (WikiPage pageVersion : pageVersions) {
                indexer.reindex((Object)pageVersion);
            }
        }
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getPageId());
        }
        return page;
    }

    public void renamePage(long userId, long nodeId, String title, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException {
        WikiPage page;
        this.validateTitle(newTitle);
        if (StringUtil.equalsIgnoreCase((String)title, (String)newTitle)) {
            throw new DuplicatePageException(newTitle);
        }
        if (this.isUsedTitle(nodeId, newTitle)) {
            page = this.getPage(nodeId, newTitle);
            if (page.getVersion() == 1.0 && page.getContent().length() < 200 || !strict) {
                this.deletePage(nodeId, newTitle);
            } else {
                throw new DuplicatePageException(newTitle);
            }
        }
        page = this.getPage(nodeId, title);
        String summary = page.getSummary();
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            page.setRedirectTitle("");
            summary = "";
        }
        serviceContext.setCommand("rename");
        this.updatePage(userId, page, 0L, newTitle, page.getContent(), summary, page.getMinorEdit(), page.getFormat(), page.getParentTitle(), page.getRedirectTitle(), serviceContext);
    }

    public void renamePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException {
        this.renamePage(userId, nodeId, title, newTitle, true, serviceContext);
    }

    public void restorePageAttachmentFromTrash(long userId, long nodeId, String title, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)page.getGroupId(), (long)page.getAttachmentsFolderId(), (String)fileName);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        extraDataJSONObject.put("fileEntryTitle", TrashUtil.getOriginalTitle((String)fileEntry.getTitle()));
        extraDataJSONObject.put("title", page.getTitle());
        extraDataJSONObject.put("version", page.getVersion());
        PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)userId, (long)fileEntry.getFileEntryId());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10010, extraDataJSONObject.toString(), 0L);
    }

    public void restorePageFromTrash(long userId, WikiPage page) throws PortalException {
        if (page.isInTrashExplicitly()) {
            this.movePageFromTrash(userId, page, page.getNodeId(), page.getParentTitle());
        } else {
            this.moveDependentFromTrash(page, page.getNodeId(), page.getParentTitle());
        }
    }

    public WikiPage revertPage(long userId, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException {
        WikiPage oldPage = this.getPage(nodeId, title, version);
        this.populateServiceContext(serviceContext, oldPage);
        return this.updatePage(userId, nodeId, title, 0.0, oldPage.getContent(), "Reverted to " + version, false, oldPage.getFormat(), this.getParentPageTitle(oldPage), oldPage.getRedirectTitle(), serviceContext);
    }

    public void subscribePage(long userId, long nodeId, String title) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.addSubscription(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long userId, long nodeId, String title) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.deleteSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void updateAsset(long userId, WikiPage page, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        int approvedPagesCount;
        boolean addDraftAssetEntry = false;
        if (!page.isApproved() && page.getVersion() != 1.0 && (approvedPagesCount = this.wikiPagePersistence.countByN_T_S(page.getNodeId(), page.getTitle(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        assetEntry = addDraftAssetEntry ? this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getPrimaryKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false) : this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, page.isApproved(), null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public WikiPage updatePage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        WikiPage oldPage = null;
        try {
            oldPage = this.wikiPagePersistence.findByN_T_First(nodeId, title, null);
            if (version > 0.0 && version != oldPage.getVersion()) {
                throw new PageVersionException();
            }
            return this.updatePage(userId, oldPage, 0L, "", content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
        }
        catch (NoSuchPageException nspe) {
            return this.addPage(userId, nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
        }
    }

    public WikiPage updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException {
        WikiPageResource pageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        List pages = this.wikiPagePersistence.findByN_T(pageResource.getNodeId(), pageResource.getTitle(), 0, 1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = null;
        if (pages.isEmpty()) {
            throw new NoSuchPageException("{resourcePrimKey=" + resourcePrimKey + "}");
        }
        page = (WikiPage)pages.get(0);
        return this.updateStatus(userId, page, status, serviceContext, new HashMap<String, Serializable>());
    }

    @Deprecated
    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, page, status, serviceContext, new HashMap<String, Serializable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        List pages;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        int oldStatus = page.getStatus();
        page.setStatus(status);
        page.setStatusByUserId(userId);
        page.setStatusByUserName(user.getFullName());
        page.setStatusDate(now);
        this.wikiPagePersistence.update((BaseModel)page);
        if (status == 0) {
            AssetEntry draftAssetEntry;
            long resourcePrimKey;
            String cmd = GetterUtil.getString((Object)workflowContext.get("command"));
            if (cmd.equals("move")) {
                resourcePrimKey = page.getResourcePrimKey();
                WikiPageResource pageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
                page = this.doChangeNode(userId, pageResource.getNodeId(), page.getTitle(), page.getNodeId(), serviceContext);
            } else if (cmd.equals("rename")) {
                resourcePrimKey = page.getResourcePrimKey();
                WikiPage oldPage = this.getPage(resourcePrimKey, true);
                page = this.doRenamePage(userId, page.getNodeId(), oldPage.getTitle(), page.getTitle(), serviceContext);
            }
            if (oldStatus != 0 && page.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(WikiPage.class.getName(), page.getPrimaryKey())) != null) {
                long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                String[] assetTagNames = draftAssetEntry.getTagNames();
                List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false);
                this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                SystemEventHierarchyEntryThreadLocal.push(WikiPage.class);
                try {
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                }
                finally {
                    SystemEventHierarchyEntryThreadLocal.pop(WikiPage.class);
                }
            }
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            if (oldStatus != 8 && page.getVersion() == 1.0 && (!page.isMinorEdit() || PropsValues.WIKI_PAGE_MINOR_EDIT_ADD_SOCIAL_ACTIVITY)) {
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", page.getTitle());
                extraDataJSONObject.put("version", page.getVersion());
                this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 1, extraDataJSONObject.toString(), 0L);
            }
            if (NotificationThreadLocal.isEnabled() && (!page.isMinorEdit() || PropsValues.WIKI_PAGE_MINOR_EDIT_SEND_EMAIL)) {
                this.notifySubscribers(page, (String)((Object)workflowContext.get("url")), serviceContext);
            }
            this.clearPageCache(page);
        }
        if (status == 0) {
            page.setHead(true);
            pages = this.wikiPagePersistence.findByN_T_H(page.getNodeId(), page.getTitle(), true);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(false);
                this.wikiPagePersistence.update((BaseModel)curPage);
            }
        } else if (status != 8) {
            page.setHead(false);
            pages = this.wikiPagePersistence.findByN_T_S(page.getNodeId(), page.getTitle(), 0);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(true);
                this.wikiPagePersistence.update((BaseModel)curPage);
                break;
            }
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
    }

    public void validateTitle(String title) throws PortalException {
        Pattern pattern;
        Matcher matcher;
        if (title.equals("all_pages") || title.equals("orphan_pages") || title.equals("recent_changes")) {
            throw new PageTitleException(title + " is reserved");
        }
        if (Validator.isNotNull((String)PropsValues.WIKI_PAGE_TITLES_REGEXP) && !(matcher = (pattern = Pattern.compile(PropsValues.WIKI_PAGE_TITLES_REGEXP)).matcher(title)).matches()) {
            throw new PageTitleException();
        }
    }

    protected void changeChildPagesNode(long userId, long nodeId, String title, long newNodeId, ServiceContext serviceContext) throws PortalException {
        List childPages = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage childPage : childPages) {
            childPage = this.doChangeNode(userId, nodeId, childPage.getTitle(), newNodeId, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)childPage);
        }
    }

    protected void changeRedirectPagesNode(long userId, long nodeId, String title, long newNodeId, ServiceContext serviceContext) throws PortalException {
        List redirectPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectPage : redirectPages) {
            redirectPage = this.doChangeNode(userId, nodeId, redirectPage.getTitle(), newNodeId, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)redirectPage);
        }
    }

    protected void checkDuplicationOnNodeChange(long nodeId, String title, long newNodeId) throws PortalException {
        WikiPage page = this.fetchPage(newNodeId, title);
        if (page != null) {
            WikiNode node = page.getNode();
            throw new NodeChangeException(node.getName(), page.getTitle(), 1);
        }
        List childPages = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage childPage : childPages) {
            this.checkDuplicationOnNodeChange(nodeId, childPage.getTitle(), newNodeId);
        }
        List redirectPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectPage : redirectPages) {
            this.checkDuplicationOnNodeChange(nodeId, redirectPage.getTitle(), newNodeId);
        }
    }

    protected void checkNodeChange(long nodeId, String title, long newNodeId) throws PortalException {
        WikiPage page = this.getPage(nodeId, title);
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            WikiNode node = page.getNode();
            throw new NodeChangeException(node.getName(), page.getTitle(), 2);
        }
        this.checkDuplicationOnNodeChange(nodeId, title, newNodeId);
    }

    protected void clearPageCache(WikiPage page) {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        WikiCacheUtil.clearCache(page.getNodeId());
    }

    protected void deletePageAttachment(long fileEntryId) throws PortalException {
        PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntryId);
    }

    protected WikiPage doChangeNode(long userId, long nodeId, String title, long newNodeId, ServiceContext serviceContext) throws PortalException {
        List versionPages = this.wikiPagePersistence.findByN_T(nodeId, title, -1, -1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = this.fetchLatestPage(newNodeId, title, -1, false);
        if (page == null) {
            page = this.getLatestPage(nodeId, title, -1, false);
        }
        for (WikiPage versionPage : versionPages) {
            versionPage.setParentTitle(page.getParentTitle());
            versionPage.setNodeId(newNodeId);
            this.wikiPagePersistence.update((BaseModel)versionPage);
        }
        long resourcePrimKey = page.getResourcePrimKey();
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        pageResource.setNodeId(newNodeId);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        this.changeChildPagesNode(userId, nodeId, title, newNodeId, serviceContext);
        this.changeRedirectPagesNode(userId, nodeId, title, newNodeId, serviceContext);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return page;
    }

    protected WikiPage doRenamePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException {
        List versionPages = this.wikiPagePersistence.findByN_T(nodeId, title, -1, -1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = this.fetchLatestPage(nodeId, newTitle, -1, false);
        if (page == null) {
            page = this.getLatestPage(nodeId, title, -1, false);
        }
        for (WikiPage versionPage : versionPages) {
            versionPage.setRedirectTitle(page.getRedirectTitle());
            versionPage.setTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)versionPage);
        }
        long resourcePrimKey = page.getResourcePrimKey();
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        pageResource.setTitle(newTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        double version = 1.0;
        String summary = LanguageUtil.format((Locale)serviceContext.getLocale(), (String)"renamed-as-x", (Object)newTitle);
        String format = page.getFormat();
        boolean head = true;
        String parentTitle = page.getParentTitle();
        String redirectTitle = page.getTitle();
        String content = "[[" + redirectTitle + "]]";
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        this.populateServiceContext(serviceContext, page);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        serviceContext.setCommand("add");
        this.addPage(userId, nodeId, title, version, content, summary, false, format, head, parentTitle, redirectTitle, serviceContext);
        WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        List childPages = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage childPage : childPages) {
            childPage.setParentTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)childPage);
        }
        List redirectPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectPage : redirectPages) {
            redirectPage.setRedirectTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)redirectPage);
        }
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return page;
    }

    protected String getDiffsURL(WikiPage page, WikiPage previousVersionPage, ServiceContext serviceContext) throws PortalException {
        if (previousVersionPage == null) {
            return "";
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        String portletId = null;
        long plid = 0L;
        String strutsAction = null;
        if (serviceContext.getPlid() != 0L) {
            portletId = "36";
            plid = serviceContext.getPlid();
            strutsAction = "/wiki/compare_versions";
        } else {
            portletId = "154";
            plid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId());
            strutsAction = "/wiki_admin/compare_versions";
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", strutsAction);
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
        portletURL.setParameter("title", page.getTitle());
        portletURL.setParameter("sourceVersion", String.valueOf(previousVersionPage.getVersion()));
        portletURL.setParameter("targetVersion", String.valueOf(page.getVersion()));
        portletURL.setParameter("type", "html");
        return portletURL.toString();
    }

    protected String getPageURL(WikiPage page, ServiceContext serviceContext) throws PortalException {
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        String layoutFullURL = this.getLayoutURL(page.getGroupId(), "36", serviceContext);
        if (Validator.isNotNull((String)layoutFullURL)) {
            return layoutFullURL + "/-/" + "wiki/" + page.getNodeId() + "/" + HttpUtil.encodeURL((String)WikiUtil.escapeName(page.getTitle()));
        }
        long controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId());
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"154", (long)controlPanelPlid, (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/wiki_admin/view_page_activities");
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
        portletURL.setParameter("title", page.getTitle());
        return portletURL.toString();
    }

    protected List<ObjectValuePair<Long, Integer>> getPageVersionStatuses(List<WikiPage> pages) {
        ArrayList<ObjectValuePair<Long, Integer>> pageVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(pages.size());
        for (WikiPage page : pages) {
            int status = page.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair pageVersionStatusOVP = new ObjectValuePair((Object)page.getPageId(), (Object)status);
            pageVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)pageVersionStatusOVP);
        }
        return pageVersionStatusOVPs;
    }

    protected String getParentPageTitle(WikiPage page) {
        try {
            WikiPage parentPage = this.getPage(page.getNodeId(), page.getParentTitle());
            return parentPage.getTitle();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isLinkedTo(WikiPage page, String targetTitle) throws PortalException {
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        Boolean link = links.get(StringUtil.toLowerCase((String)targetTitle));
        return link != null;
    }

    protected boolean isUsedTitle(long nodeId, String title) {
        return this.getPagesCount(nodeId, title, true) > 0;
    }

    protected void moveDependentChildPagesFromTrash(WikiPage page, long nodeId, String title, String trashTitle) throws PortalException {
        List<WikiPage> childPages = this.getChildren(nodeId, true, trashTitle, 8);
        for (WikiPage childPage : childPages) {
            childPage.setParentTitle(title);
            this.wikiPagePersistence.update((BaseModel)childPage);
            if (childPage.isInTrashExplicitly()) continue;
            this.moveDependentFromTrash(childPage, page.getNodeId(), title);
        }
    }

    protected void moveDependentChildPagesToTrash(WikiPage page, String title, String trashTitle, long trashEntryId, boolean createTrashVersion) throws PortalException {
        List childPages = this.wikiPagePersistence.findByN_H_P(page.getNodeId(), true, title);
        for (WikiPage childPage : childPages) {
            childPage.setParentTitle(trashTitle);
            this.wikiPagePersistence.update((BaseModel)childPage);
            if (childPage.isInTrashExplicitly()) continue;
            this.moveDependentToTrash(childPage, trashEntryId, createTrashVersion);
        }
    }

    protected void moveDependentFromTrash(WikiPage page, long newNodeId, String newParentTitle) throws PortalException {
        String trashTitle = page.getTitle();
        TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(WikiPage.class.getName(), page.getPageId());
        long oldNodeId = page.getNodeId();
        if (newNodeId == 0L) {
            newNodeId = oldNodeId;
        }
        page.setNodeId(newNodeId);
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(page.getResourcePrimKey());
        pageResource.setNodeId(newNodeId);
        if (trashVersion != null) {
            String originalTitle = TrashUtil.getOriginalTitle((String)page.getTitle());
            pageResource.setTitle(originalTitle);
            page.setTitle(originalTitle);
        }
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setParentTitle(newParentTitle);
        this.wikiPagePersistence.update((BaseModel)page);
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
        for (WikiPage versionPage : versionPages) {
            versionPage.setParentTitle(newParentTitle);
            versionPage.setNodeId(newNodeId);
            versionPage.setTitle(page.getTitle());
            trashVersion = this.trashVersionLocalService.fetchVersion(WikiPage.class.getName(), versionPage.getPageId());
            int versionPageOldStatus = 0;
            if (trashVersion != null) {
                versionPageOldStatus = trashVersion.getStatus();
            }
            versionPage.setStatus(versionPageOldStatus);
            this.wikiPagePersistence.update((BaseModel)versionPage);
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        this.moveDependentChildPagesFromTrash(page, oldNodeId, page.getTitle(), trashTitle);
        this.moveDependentRedirectPagesFromTrash(page, oldNodeId, page.getTitle(), trashTitle);
    }

    protected void moveDependentRedirectPagesFromTrash(WikiPage page, long nodeId, String title, String trashTitle) throws PortalException {
        List<WikiPage> redirectPages = this.getRedirectPages(nodeId, true, trashTitle, 8);
        for (WikiPage curPage : redirectPages) {
            curPage.setRedirectTitle(title);
            this.wikiPagePersistence.update((BaseModel)curPage);
            if (curPage.isInTrash()) continue;
            this.moveDependentFromTrash(curPage, page.getNodeId(), curPage.getParentTitle());
        }
    }

    protected void moveDependentRedirectPagesToTrash(WikiPage page, String title, String trashTitle, long trashEntryId, boolean createTrashVersion) throws PortalException {
        List redirectPages = this.wikiPagePersistence.findByN_H_R(page.getNodeId(), true, title);
        for (WikiPage redirectPage : redirectPages) {
            redirectPage.setRedirectTitle(trashTitle);
            this.wikiPagePersistence.update((BaseModel)redirectPage);
            if (redirectPage.isInTrash()) continue;
            this.moveDependentToTrash(redirectPage, trashEntryId, createTrashVersion);
        }
    }

    protected void moveDependentToTrash(WikiPage page, long trashEntryId, boolean createTrashVersion) throws PortalException {
        int oldStatus;
        String title;
        String trashTitle = title = page.getTitle();
        if (createTrashVersion) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties();
            typeSettingsProperties.put("title", page.getTitle());
            TrashVersion trashVersion = this.trashVersionLocalService.addTrashVersion(trashEntryId, WikiPage.class.getName(), page.getPageId(), page.getStatus(), typeSettingsProperties);
            trashTitle = TrashUtil.getTrashTitle((long)trashVersion.getVersionId());
            WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(page.getResourcePrimKey());
            pageResource.setTitle(trashTitle);
            this.wikiPageResourcePersistence.update((BaseModel)pageResource);
            page.setTitle(trashTitle);
            this.wikiPagePersistence.update((BaseModel)page);
        }
        if ((oldStatus = page.getStatus()) == 8) {
            return;
        }
        List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
        for (WikiPage versionPage : versionPages) {
            versionPage.setTitle(page.getTitle());
            int versionPageOldStatus = versionPage.getStatus();
            versionPage.setStatus(8);
            this.wikiPagePersistence.update((BaseModel)versionPage);
            int status = versionPageOldStatus;
            if (versionPageOldStatus == 1) {
                status = 2;
            }
            if (versionPageOldStatus == 0) continue;
            this.trashVersionLocalService.addTrashVersion(trashEntryId, WikiPage.class.getName(), versionPage.getPageId(), status, null);
        }
        if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        if (WikiCacheThreadLocal.isClearCache()) {
            WikiCacheUtil.clearCache(page.getNodeId());
        }
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
        }
        this.moveDependentChildPagesToTrash(page, title, trashTitle, trashEntryId, createTrashVersion);
        this.moveDependentRedirectPagesToTrash(page, title, trashTitle, trashEntryId, createTrashVersion);
    }

    protected void movePageFromTrash(long userId, WikiPage page, long newNodeId, String newParentTitle) throws PortalException {
        WikiPage redirectPage;
        WikiPage newParentPage;
        String trashTitle = page.getTitle();
        String originalTitle = TrashUtil.getOriginalTitle((String)trashTitle);
        long oldNodeId = page.getNodeId();
        if (newNodeId == 0L) {
            newNodeId = oldNodeId;
        }
        List pageVersions = this.wikiPagePersistence.findByR_N_H(page.getResourcePrimKey(), oldNodeId, false);
        for (WikiPage pageVersion : pageVersions) {
            pageVersion.setParentTitle(newParentTitle);
            pageVersion.setNodeId(newNodeId);
            pageVersion.setTitle(originalTitle);
            this.wikiPagePersistence.update((BaseModel)pageVersion);
        }
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByPrimaryKey(page.getResourcePrimKey());
        pageResource.setNodeId(newNodeId);
        pageResource.setTitle(originalTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setNodeId(newNodeId);
        page.setTitle(originalTitle);
        WikiPage parentPage = page.getParentPage();
        if (parentPage != null && parentPage.isInTrash()) {
            page.setParentTitle("");
        }
        if (Validator.isNotNull((String)newParentTitle) && !(newParentPage = this.getPage(newNodeId, newParentTitle)).isInTrash()) {
            page.setParentTitle(newParentTitle);
        }
        if ((redirectPage = page.getRedirectPage()) != null && redirectPage.isInTrash()) {
            page.setRedirectTitle("");
        }
        this.wikiPagePersistence.update((BaseModel)page);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this.updateStatus(userId, page, trashEntry.getStatus(), new ServiceContext(), new HashMap<String, Serializable>());
        this.moveDependentChildPagesFromTrash(page, oldNodeId, originalTitle, trashTitle);
        this.moveDependentRedirectPagesFromTrash(page, oldNodeId, originalTitle, trashTitle);
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            WikiPage trashArticleVersion = this.wikiPagePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashVersion.getStatus());
            this.wikiPagePersistence.update((BaseModel)trashArticleVersion);
        }
        this.trashEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", page.getTitle());
        extraDataJSONObject.put("version", page.getVersion());
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10008, extraDataJSONObject.toString(), 0L);
        if (!pageVersions.isEmpty()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            for (WikiPage pageVersion : pageVersions) {
                indexer.reindex((Object)pageVersion);
            }
        }
    }

    protected void notifySubscribers(WikiPage page, String pageURL, ServiceContext serviceContext) throws PortalException {
        if (!page.isApproved() || Validator.isNull((String)pageURL)) {
            return;
        }
        WikiSettings wikiSettings = WikiSettings.getInstance(page.getGroupId());
        boolean update = false;
        if (page.getVersion() > 1.0) {
            update = true;
        }
        if (!(!update && wikiSettings.isEmailPageAddedEnabled() || update && wikiSettings.isEmailPageUpdatedEnabled())) {
            return;
        }
        String portalURL = serviceContext.getPortalURL();
        WikiPage previousVersionPage = this.getPreviousVersionPage(page);
        String attachmentURLPrefix = WikiUtil.getAttachmentURLPrefix(serviceContext.getPathMain(), serviceContext.getPlid(), page.getNodeId(), page.getTitle());
        attachmentURLPrefix = portalURL + attachmentURLPrefix;
        String pageDiffs = "";
        try {
            pageDiffs = WikiUtil.diffHtml(previousVersionPage, page, null, null, attachmentURLPrefix);
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageContent = null;
        if (Validator.equals((Object)page.getFormat(), (Object)"creole")) {
            pageContent = WikiUtil.convert(page, null, null, attachmentURLPrefix);
        } else {
            pageContent = page.getContent();
            pageContent = WikiUtil.processContent(pageContent);
        }
        String pageTitle = page.getTitle();
        String fromName = wikiSettings.getEmailFromName();
        String fromAddress = wikiSettings.getEmailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (update) {
            subjectLocalizedValuesMap = wikiSettings.getEmailPageUpdatedSubject();
            bodyLocalizedValuesMap = wikiSettings.getEmailPageUpdatedBody();
        } else {
            subjectLocalizedValuesMap = wikiSettings.getEmailPageAddedSubject();
            bodyLocalizedValuesMap = wikiSettings.getEmailPageAddedBody();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setClassName(page.getModelClassName());
        subscriptionSender.setClassPK(page.getPageId());
        subscriptionSender.setCompanyId(page.getCompanyId());
        subscriptionSender.setContextAttribute("[$PAGE_CONTENT$]", (Object)pageContent, false);
        subscriptionSender.setContextAttribute("[$PAGE_DIFFS$]", (Object)DiffHtmlUtil.replaceStyles((String)pageDiffs), false);
        WikiNode node = page.getNode();
        subscriptionSender.setContextAttributes(new Object[]{"[$DIFFS_URL$]", this.getDiffsURL(page, previousVersionPage, serviceContext), "[$NODE_NAME$]", node.getName(), "[$PAGE_DATE_UPDATE$]", page.getModifiedDate(), "[$PAGE_ID$]", page.getPageId(), "[$PAGE_SUMMARY$]", page.getSummary(), "[$PAGE_TITLE$]", pageTitle, "[$PAGE_URL$]", pageURL});
        subscriptionSender.setContextUserPrefix("PAGE");
        subscriptionSender.setEntryTitle(pageTitle);
        subscriptionSender.setEntryURL(pageURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap((Map)bodyLocalizedValuesMap);
        subscriptionSender.setLocalizedSubjectMap((Map)subjectLocalizedValuesMap);
        subscriptionSender.setMailId("wiki_page", new Object[]{page.getNodeId(), page.getPageId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("36");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(page.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(page.getUserId());
        subscriptionSender.addPersistedSubscribers(WikiNode.class.getName(), page.getNodeId());
        subscriptionSender.addPersistedSubscribers(WikiPage.class.getName(), page.getResourcePrimKey());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void populateServiceContext(ServiceContext serviceContext, WikiPage page) throws PortalException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getLinks(assetEntry.getEntryId());
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetTagNames(assetTagNames);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
    }

    protected void startWorkflowInstance(long userId, WikiPage page, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("command", serviceContext.getCommand());
        workflowContext.put("url", this.getPageURL(page, serviceContext));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)page.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getPageId(), (Object)page, (ServiceContext)serviceContext, workflowContext);
    }

    protected WikiPage updatePage(long userId, WikiPage oldPage, long newNodeId, String newTitle, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long pageId = 0L;
        pageId = oldPage.isApproved() ? this.counterLocalService.increment() : oldPage.getPageId();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)oldPage.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        long nodeId = oldPage.getNodeId();
        if (newNodeId != 0L) {
            nodeId = newNodeId;
        }
        this.validate(nodeId, content, format);
        serviceContext.validateModifiedDate((AuditedModel)oldPage, PageVersionException.class);
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(oldPage.getNodeId(), oldPage.getTitle());
        Date now = new Date();
        WikiPage page = oldPage;
        double newVersion = oldPage.getVersion();
        if (oldPage.isApproved()) {
            newVersion = MathUtil.format((double)(oldPage.getVersion() + 0.1), (int)1, (int)1);
            page = this.wikiPagePersistence.create(pageId);
            page.setUuid(serviceContext.getUuid());
        }
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(oldPage.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(oldPage.getCreateDate());
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(Validator.isNull((String)newTitle) ? oldPage.getTitle() : newTitle);
        page.setVersion(newVersion);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        if (oldPage.isPending()) {
            page.setStatus(oldPage.getStatus());
        } else {
            page.setStatus(2);
        }
        page.setSummary(summary);
        page.setFormat(format);
        if (Validator.isNotNull((String)parentTitle)) {
            page.setParentTitle(parentTitle);
        }
        if (Validator.isNotNull((String)redirectTitle)) {
            page.setRedirectTitle(redirectTitle);
        }
        page.setExpandoBridgeAttributes(serviceContext);
        this.wikiPagePersistence.update((BaseModel)page);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (!page.isMinorEdit() || PropsValues.WIKI_PAGE_MINOR_EDIT_ADD_SOCIAL_ACTIVITY) {
            if (oldPage.getVersion() == newVersion) {
                SocialActivity lastSocialActivity = this.socialActivityLocalService.fetchFirstActivity(WikiPage.class.getName(), page.getResourcePrimKey(), 2);
                if (lastSocialActivity != null) {
                    lastSocialActivity.setCreateDate(now.getTime() + 1L);
                    lastSocialActivity.setUserId(serviceContext.getUserId());
                    this.socialActivityPersistence.update((BaseModel)lastSocialActivity);
                }
            } else {
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", page.getTitle());
                extraDataJSONObject.put("version", page.getVersion());
                this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 2, extraDataJSONObject.toString(), 0L);
            }
        }
        this.startWorkflowInstance(userId, page, serviceContext);
        return page;
    }

    protected void validate(long nodeId, String content, String format) throws PortalException {
        if (!WikiUtil.validate(nodeId, content, format)) {
            throw new PageContentException();
        }
    }

    protected void validate(String title, long nodeId, String content, String format) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new PageTitleException();
        }
        if (this.isUsedTitle(nodeId, title)) {
            throw new DuplicatePageException("{nodeId=" + nodeId + "}");
        }
        this.validateTitle(title);
        this.validate(nodeId, content, format);
    }
}

