/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntrySoap;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageSoap;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;

@ProviderType
public class WikiPageServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(WikiPageServiceSoap.class);

    public static WikiPageSoap addPage(long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.addPage((long)nodeId, (String)title, (String)content, (String)summary, (boolean)minorEdit, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap addPage(long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.addPage((long)nodeId, (String)title, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws RemoteException {
        try {
            WikiPageServiceUtil.addPageAttachments((long)nodeId, (String)title, inputStreamOVPs);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void changeNode(long nodeId, String title, long newNodeId, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.changeNode((long)nodeId, (String)title, (long)newNodeId, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void changeParent(long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.changeParent((long)nodeId, (String)title, (String)newParentTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void copyPageAttachments(long templateNodeId, String templateTitle, long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.copyPageAttachments((long)templateNodeId, (String)templateTitle, (long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deletePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePage((long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static void deletePage(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePage((long)nodeId, (String)title, (double)version);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deletePageAttachment(long nodeId, String title, String fileName) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePageAttachment((long)nodeId, (String)title, (String)fileName);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deletePageAttachments(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePageAttachments((long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTempFileEntry(long nodeId, String folderName, String fileName) throws RemoteException {
        try {
            WikiPageServiceUtil.deleteTempFileEntry((long)nodeId, (String)folderName, (String)fileName);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTrashPageAttachments(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.deleteTrashPageAttachments((long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void discardDraft(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPageServiceUtil.discardDraft((long)nodeId, (String)title, (double)version);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap fetchPage(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.fetchPage((long)nodeId, (String)title, (double)version);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getChildren(long groupId, long nodeId, boolean head, String parentTitle) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getChildren((long)groupId, (long)nodeId, (boolean)head, (String)parentTitle);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap getDraftPage(long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getDraftPage((long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getNodePages(long nodeId, int max) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getNodePages((long)nodeId, (int)max);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getNodePagesRSS((long)nodeId, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getNodePagesRSS((long)nodeId, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL, (String)attachmentURLPrefix);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getOrphans(long groupId, long nodeId) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getOrphans((long)groupId, (long)nodeId);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap getPage(long groupId, long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)groupId, (long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title, Boolean head) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (Boolean)head);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getPages(long groupId, long nodeId, boolean head, int status, int start, int end, OrderByComparator<WikiPage> obc) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getPages((long)groupId, (long)nodeId, (boolean)head, (int)status, (int)start, (int)end, obc);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getPages(long groupId, long userId, long nodeId, int status, int start, int end) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getPages((long)groupId, (long)userId, (long)nodeId, (int)status, (int)start, (int)end);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getPagesCount(long groupId, long nodeId, boolean head) throws RemoteException {
        try {
            int returnValue = WikiPageServiceUtil.getPagesCount((long)groupId, (long)nodeId, (boolean)head);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getPagesCount(long groupId, long userId, long nodeId, int status) throws RemoteException {
        try {
            int returnValue = WikiPageServiceUtil.getPagesCount((long)groupId, (long)userId, (long)nodeId, (int)status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String locale) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getPagesRSS((long)companyId, (long)nodeId, (String)title, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL, (Locale)LocaleUtil.fromLanguageId((String)locale));
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, String locale) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getPagesRSS((long)companyId, (long)nodeId, (String)title, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL, (String)attachmentURLPrefix, (Locale)LocaleUtil.fromLanguageId((String)locale));
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap[] getRecentChanges(long groupId, long nodeId, int start, int end) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getRecentChanges((long)groupId, (long)nodeId, (int)start, (int)end);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getRecentChangesCount(long groupId, long nodeId) throws RemoteException {
        try {
            int returnValue = WikiPageServiceUtil.getRecentChangesCount((long)groupId, (long)nodeId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String[] getTempFileNames(long nodeId, String folderName) throws RemoteException {
        try {
            String[] returnValue = WikiPageServiceUtil.getTempFileNames((long)nodeId, (String)folderName);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void movePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.movePage((long)nodeId, (String)title, (String)newTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap movePageAttachmentToTrash(long nodeId, String title, String fileName) throws RemoteException {
        try {
            FileEntry returnValue = WikiPageServiceUtil.movePageAttachmentToTrash((long)nodeId, (String)title, (String)fileName);
            return FileEntrySoap.toSoapModel((FileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap movePageToTrash(long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.movePageToTrash((long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap movePageToTrash(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.movePageToTrash((long)nodeId, (String)title, (double)version);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void renamePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.renamePage((long)nodeId, (String)title, (String)newTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void restorePageAttachmentFromTrash(long nodeId, String title, String fileName) throws RemoteException {
        try {
            WikiPageServiceUtil.restorePageAttachmentFromTrash((long)nodeId, (String)title, (String)fileName);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void restorePageFromTrash(long resourcePrimKey) throws RemoteException {
        try {
            WikiPageServiceUtil.restorePageFromTrash((long)resourcePrimKey);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap revertPage(long nodeId, String title, double version, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.revertPage((long)nodeId, (String)title, (double)version, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void subscribePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.subscribePage((long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsubscribePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.unsubscribePage((long)nodeId, (String)title);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiPageSoap updatePage(long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.updatePage((long)nodeId, (String)title, (double)version, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

