/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@ProviderType
public class WikiNodeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeServiceHttp.class);
    private static final Class<?>[] _addNodeParameterTypes0 = new Class[]{String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteNodeParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes3 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getNodesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodesParameterTypes5 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesParameterTypes6 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesParameterTypes7 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesCountParameterTypes8 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodesCountParameterTypes9 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _importPagesParameterTypes10 = new Class[]{Long.TYPE, String.class, InputStream[].class, Map.class};
    private static final Class<?>[] _moveNodeToTrashParameterTypes11 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreNodeFromTrashParameterTypes12 = new Class[]{Long.TYPE};
    private static final Class<?>[] _subscribeNodeParameterTypes13 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsubscribeNodeParameterTypes14 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateNodeParameterTypes15 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};

    public static WikiNode addNode(HttpPrincipal httpPrincipal, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "addNode", (Class[])_addNodeParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "deleteNode", (Class[])_deleteNodeParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int status, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getNodesCount(HttpPrincipal httpPrincipal, long groupId) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodesCount", (Class[])_getNodesCountParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getNodesCount(HttpPrincipal httpPrincipal, long groupId, int status) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodesCount", (Class[])_getNodesCountParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPages(HttpPrincipal httpPrincipal, long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "importPages", (Class[])_importPagesParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, importer, inputStreams, options});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode moveNodeToTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "moveNodeToTrash", (Class[])_moveNodeToTrashParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void restoreNodeFromTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "restoreNodeFromTrash", (Class[])_restoreNodeFromTrashParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void subscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "subscribeNode", (Class[])_subscribeNodeParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsubscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "unsubscribeNode", (Class[])_unsubscribeNodeParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode updateNode(HttpPrincipal httpPrincipal, long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "updateNode", (Class[])_updateNodeParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

