/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "wiki";

    public WikiPortletDataHandler() {
        this.setDataPortletPreferences(new String[]{"hiddenNodes, visibleNodes"});
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(WikiNode.class), new StagedModelType(WikiPage.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "wiki-pages", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content")}, WikiPage.class.getName())});
        this.setImportControls(this.getExportControls());
        XStreamAliasRegistryUtil.register(WikiNodeImpl.class, (String)"WikiNode");
        XStreamAliasRegistryUtil.register(WikiPageImpl.class, (String)"WikiPage");
    }

    public String getServiceName() {
        return "com.liferay.portlet.wiki";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(WikiPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        WikiNodeLocalServiceUtil.deleteNodes((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPortletPermissions("com.liferay.portlet.wiki");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery nodeActionableDynamicQuery = WikiNodeLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        nodeActionableDynamicQuery.performActions();
        ExportActionableDynamicQuery pageActionableDynamicQuery = WikiPageLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        pageActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return null;
        }
        portletDataContext.importPortletPermissions("com.liferay.portlet.wiki");
        Element nodesElement = portletDataContext.getImportDataGroupElement(WikiNode.class);
        List nodeElements = nodesElement.elements();
        for (Element nodeElement : nodeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)nodeElement);
        }
        Element pagesElement = portletDataContext.getImportDataGroupElement(WikiPage.class);
        List pageElements = pagesElement.elements();
        for (Element pageElement : pageElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)pageElement);
        }
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        Iterator i$ = nodeIds.values().iterator();
        while (i$.hasNext()) {
            long nodeId = (Long)i$.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ExportActionableDynamicQuery nodeActionableDynamicQuery = WikiNodeLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        nodeActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery pageExportActionableDynamicQuery = WikiPageLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        pageExportActionableDynamicQuery.performCount();
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        String hiddenNodeNames = portletPreferences.getValue("hiddenNodes", null);
        for (String hiddenNodeName : StringUtil.split((String)hiddenNodeNames)) {
            WikiNode wikiNode = WikiNodeLocalServiceUtil.getNode((long)portletDataContext.getScopeGroupId(), (String)hiddenNodeName);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)wikiNode);
        }
        String visibleNodeNames = portletPreferences.getValue("visibleNodes", null);
        for (String visibleNodeName : StringUtil.split((String)visibleNodeNames)) {
            WikiNode wikiNode = WikiNodeLocalServiceUtil.getNode((long)portletDataContext.getScopeGroupId(), (String)visibleNodeName);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)wikiNode);
        }
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, WikiNode.class);
        return portletPreferences;
    }
}

