/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class WikiPageStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiPage> {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(WikiPageStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        WikiPage wikiPage = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (wikiPage != null) {
            WikiPageLocalServiceUtil.deletePage((WikiPage)wikiPage);
        }
    }

    public WikiPage fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List pages = WikiPageLocalServiceUtil.getWikiPagesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)pages)) {
            return null;
        }
        return (WikiPage)pages.get(0);
    }

    public WikiPage fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return WikiPageLocalServiceUtil.fetchWikiPageByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, (StagedModel)page.getNode(), (String)"parent");
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)page, (String)page.getContent(), (boolean)portletDataContext.getBooleanParameter("wiki", "referenced-content"));
        page.setContent(content);
        if (page.isHead()) {
            for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, (StagedModel)fileEntry, (String)"weak");
            }
        }
        Element pageElement = portletDataContext.getExportDataElement((ClassedModel)page);
        portletDataContext.addClassedModel(pageElement, ExportImportPathUtil.getModelPath((StagedModel)page), (ClassedModel)page);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long pageId) throws Exception {
        WikiPage existingPage = (WikiPage)this.fetchMissingReference(uuid, groupId);
        Map pageIds = portletDataContext.getNewPrimaryKeysMap(WikiPage.class);
        pageIds.put(pageId, existingPage.getPageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        Element pageElement = portletDataContext.getImportDataStagedModelElement((StagedModel)page);
        String content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)page, (String)page.getContent());
        page.setContent(content);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)page);
        serviceContext.setUuid(page.getUuid());
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        long nodeId = MapUtil.getLong((Map)nodeIds, (long)page.getNodeId(), (long)page.getNodeId());
        WikiPage importedPage = null;
        WikiPage existingPage = WikiPageLocalServiceUtil.fetchPage((long)nodeId, (String)page.getTitle());
        if (existingPage == null) {
            importedPage = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        } else {
            existingPage = this.fetchStagedModelByUuidAndGroupId(page.getUuid(), portletDataContext.getScopeGroupId());
            if (existingPage == null) {
                existingPage = WikiPageLocalServiceUtil.fetchPage((long)nodeId, (String)page.getTitle(), (double)page.getVersion());
            }
            importedPage = existingPage == null ? WikiPageLocalServiceUtil.updatePage((long)userId, (long)nodeId, (String)page.getTitle(), (double)0.0, (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext) : existingPage;
        }
        if (page.isHead()) {
            List attachmentElements = portletDataContext.getReferenceDataElements(pageElement, DLFileEntry.class, "weak");
            for (Element attachmentElement : attachmentElements) {
                String mimeType;
                InputStream inputStream;
                FileEntry fileEntry;
                block12: {
                    block13: {
                        String path = attachmentElement.attributeValue("path");
                        fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                        inputStream = null;
                        mimeType = null;
                        try {
                            String binPath = attachmentElement.attributeValue("bin-path");
                            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                                try {
                                    inputStream = FileEntryUtil.getContentStream(fileEntry);
                                }
                                catch (NoSuchFileException nsfe) {}
                            } else {
                                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                            }
                            if (inputStream != null) break block12;
                            if (!_log.isWarnEnabled()) break block13;
                            _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                        }
                        catch (Throwable throwable) {
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                            throw throwable;
                        }
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    continue;
                }
                mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)fileEntry.getTitle());
                WikiPageLocalServiceUtil.addPageAttachment((long)userId, (long)importedPage.getNodeId(), (String)importedPage.getTitle(), (String)fileEntry.getTitle(), (InputStream)inputStream, (String)mimeType);
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
        }
        portletDataContext.importClassedModel((ClassedModel)page, (ClassedModel)importedPage);
        Map pageIds = portletDataContext.getNewPrimaryKeysMap(WikiPage.class + ".pageId");
        pageIds.put(page.getPageId(), importedPage.getPageId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        WikiPage existingPage = this.fetchStagedModelByUuidAndGroupId(page.getUuid(), portletDataContext.getScopeGroupId());
        if (existingPage == null || !existingPage.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingPage.getTrashHandler();
        if (trashHandler.isRestorable(existingPage.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingPage.getResourcePrimKey());
        }
    }
}

