/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.wiki.lar.WikiPortletDataHandler;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiDisplayPortletDataHandler
extends WikiPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(WikiDisplayPortletDataHandler.class);

    public WikiDisplayPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"title", "nodeId"});
        this.setExportControls(new PortletDataHandlerControl[0]);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("title", "");
        portletPreferences.setValue("nodeId", "");
        return portletPreferences;
    }

    @Override
    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No node id found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        String title = portletPreferences.getValue("title", null);
        if (title == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No title found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        WikiNode node = WikiNodeUtil.fetchByPrimaryKey((long)nodeId);
        if (node == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to find wiki node");
            }
            return portletPreferences;
        }
        portletDataContext.addPortletPermissions("com.liferay.portlet.wiki");
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)node);
        ActionableDynamicQuery actionableDynamicQuery = this.getPageActionableDynamicQuery(portletDataContext, node.getNodeId(), portletId);
        actionableDynamicQuery.performActions();
        return portletPreferences;
    }

    @Override
    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.wiki");
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, WikiNode.class);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, WikiPage.class);
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId > 0L) {
            Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
            nodeId = MapUtil.getLong((Map)nodeIds, (long)nodeId, (long)nodeId);
            portletPreferences.setValue("nodeId", String.valueOf(nodeId));
        }
        return portletPreferences;
    }

    protected ActionableDynamicQuery getPageActionableDynamicQuery(final PortletDataContext portletDataContext, final long nodeId, final String portletId) {
        ExportActionableDynamicQuery actionableDynamicQuery = WikiPageLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = actionableDynamicQuery.getAddCriteriaMethod();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"nodeId");
                dynamicQuery.add(property.eq((Object)nodeId));
            }
        });
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                WikiPage page = (WikiPage)object;
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)page);
            }
        });
        return actionableDynamicQuery;
    }
}

