/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.wiki.WikiPortletInstanceSettings;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WikiConfigurationDisplayContext {
    private List<String> _allNodeNames;
    private List<WikiNode> _allNodes;
    private long _scopeGroupId;
    private String[] _visibleNodeNames;
    private WikiPortletInstanceSettings _wikiPortletInstanceSettings;

    public WikiConfigurationDisplayContext(HttpServletRequest request, WikiPortletInstanceSettings wikiPortletInstanceSettings) {
        this._wikiPortletInstanceSettings = wikiPortletInstanceSettings;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._scopeGroupId = themeDisplay.getScopeGroupId();
    }

    public List<String> getAllNodeNames() throws PortalException {
        if (this._allNodeNames == null) {
            this._populateNodes();
        }
        return this._allNodeNames;
    }

    public List<WikiNode> getAllNodes() throws PortalException {
        if (this._allNodes == null) {
            this._populateNodes();
        }
        return this._allNodes;
    }

    public String[] getVisibleNodeNames() throws PortalException {
        if (this._visibleNodeNames == null) {
            this._populateNodes();
        }
        return this._visibleNodeNames;
    }

    private void _populateNodes() throws PortalException {
        this._allNodes = WikiNodeServiceUtil.getNodes((long)this._scopeGroupId);
        this._allNodeNames = WikiUtil.getNodeNames(this._allNodes);
        this._visibleNodeNames = this._wikiPortletInstanceSettings.getVisibleNodes();
        if (ArrayUtil.isNotEmpty((Object[])this._visibleNodeNames)) {
            this._allNodes = WikiUtil.orderNodes(this._allNodes, this._visibleNodeNames);
        } else {
            this._visibleNodeNames = this._allNodeNames.toArray(new String[this._allNodeNames.size()]);
        }
    }
}

