/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.wiki.asset.WikiPageAssetRenderer;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class WikiPageAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "wiki";

    public WikiPageAssetRendererFactory() {
        this.setLinkable(true);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        WikiPage page = WikiPageLocalServiceUtil.fetchWikiPage((long)classPK);
        if (page == null) {
            if (type == 1) {
                page = WikiPageLocalServiceUtil.getPage((long)classPK);
            } else {
                WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)classPK);
                page = WikiPageLocalServiceUtil.getPage((long)pageResource.getNodeId(), (String)pageResource.getTitle(), null);
            }
        }
        WikiPageAssetRenderer wikiPageAssetRenderer = new WikiPageAssetRenderer(page);
        wikiPageAssetRenderer.setAssetRendererType(type);
        return wikiPageAssetRenderer;
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public String getIconCssClass() {
        return "icon-file-alt";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("36", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return WikiPagePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/pages.png";
    }
}

