/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportPagesAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.importPages(actionRequest, actionResponse);
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e instanceof PortalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.import_pages"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPages(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String importProgressId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"importProgressId");
        ProgressTracker progressTracker = new ProgressTracker(importProgressId);
        ProgressTrackerThreadLocal.setProgressTracker((ProgressTracker)progressTracker);
        progressTracker.start((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"nodeId");
        String importer = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"importer");
        int filesCount = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"filesCount", (int)10);
        InputStream[] inputStreams = new InputStream[filesCount];
        try {
            for (int i = 0; i < filesCount; ++i) {
                inputStreams[i] = uploadPortletRequest.getFileAsStream("file" + i);
            }
            NotificationThreadLocal.setEnabled((boolean)false);
            WikiCacheThreadLocal.setClearCache(false);
            WikiNodeServiceUtil.importPages((long)nodeId, (String)importer, (InputStream[])inputStreams, (Map)actionRequest.getParameterMap());
        }
        catch (Throwable throwable) {
            for (InputStream inputStream : inputStreams) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (InputStream inputStream : inputStreams) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        WikiCacheUtil.clearCache(nodeId);
        progressTracker.finish((PortletRequest)actionRequest);
    }
}

