/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.action.EditFileEntryAction;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiPageAttachmentsUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPageAttachmentsAction
extends EditFileEntryAction {
    private static final String _TEMP_FOLDER_NAME = EditPageAttachmentsAction.class.getName();

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededSizeLimit()) {
                    throw new FileSizeException(uploadException.getCause());
                }
                throw new PortalException(uploadException.getCause());
            }
            if (cmd.equals("add")) {
                this.addAttachment(actionRequest);
            } else if (cmd.equals("add_multiple")) {
                this.addMultipleFileEntries(portletConfig, actionRequest, actionResponse);
            } else if (cmd.equals("add_temp")) {
                this.addTempAttachment(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest, false);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempAttachment(actionRequest, actionResponse);
            } else if (cmd.equals("empty_trash")) {
                this.emptyTrash(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteAttachment(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreAttachment(actionRequest);
            }
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
            } else {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof NoSuchPageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            this.handleUploadException(portletConfig, actionRequest, actionResponse, cmd, e);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode((PortletRequest)renderRequest);
            ActionUtil.getPage((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof NoSuchPageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_page_attachment"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAttachment(ActionRequest actionRequest) throws Exception {
        InputStream inputStream;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        int numOfFiles = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"numOfFiles");
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            if (numOfFiles == 0) {
                String fileName = uploadPortletRequest.getFileName("file");
                InputStream inputStream2 = uploadPortletRequest.getFileAsStream("file");
                if (inputStream2 != null) {
                    ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream2);
                    inputStreamOVPs.add(inputStreamOVP);
                }
            } else {
                for (int i = 1; i <= numOfFiles; ++i) {
                    String fileName = uploadPortletRequest.getFileName("file" + i);
                    inputStream = uploadPortletRequest.getFileAsStream("file" + i);
                    if (inputStream == null) continue;
                    ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                    inputStreamOVPs.add(inputStreamOVP);
                }
            }
            WikiPageServiceUtil.addPageAttachments((long)nodeId, (String)title, inputStreamOVPs);
        }
        catch (Throwable throwable) {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream3 = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream3});
            }
            throw throwable;
        }
        for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addMultipleFileEntries(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String selectedFileName, List<KeyValuePair> validFileNameKVPs, List<KeyValuePair> invalidFileNameKVPs) throws Exception {
        String originalSelectedFileName = selectedFileName;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        FileEntry tempFileEntry = null;
        try {
            tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)selectedFileName);
            InputStream inputStream = tempFileEntry.getContentStream();
            String mimeType = tempFileEntry.getMimeType();
            WikiPageServiceUtil.addPageAttachment((long)nodeId, (String)title, (String)selectedFileName, (InputStream)inputStream, (String)mimeType);
            validFileNameKVPs.add(new KeyValuePair(selectedFileName, originalSelectedFileName));
        }
        catch (Exception e) {
            String errorMessage = this.getAddMultipleFileEntriesErrorMessage(portletConfig, actionRequest, actionResponse, e);
            KeyValuePair invalidFileNameKVP = new KeyValuePair(selectedFileName, errorMessage);
            invalidFileNameKVPs.add(invalidFileNameKVP);
        }
        finally {
            if (tempFileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempAttachment(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String mimeType = uploadPortletRequest.getContentType("file");
            WikiPageServiceUtil.addTempFileEntry((long)nodeId, (String)_TEMP_FOLDER_NAME, (String)sourceFileName, (InputStream)inputStream, (String)mimeType);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void deleteAttachment(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String attachment = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        DLFileEntry trashedModel = null;
        if (moveToTrash) {
            FileEntry fileEntry = WikiPageServiceUtil.movePageAttachmentToTrash((long)nodeId, (String)title, (String)attachment);
            if (fileEntry.getModel() instanceof DLFileEntry) {
                trashedModel = (DLFileEntry)fileEntry.getModel();
            }
        } else {
            WikiPageServiceUtil.deletePageAttachment((long)nodeId, (String)title, (String)attachment);
        }
        if (moveToTrash && trashedModel != null) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModel, (String)"remove");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void deleteTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            WikiPageServiceUtil.deleteTempFileEntry((long)nodeId, (String)fileName, (String)_TEMP_FOLDER_NAME);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        WikiPageServiceUtil.deleteTrashPageAttachments((long)nodeId, (String)title);
    }

    protected void restoreAttachment(ActionRequest actionRequest) throws Exception {
        long[] restoreEntryIds;
        for (long restoreEntryId : restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            TrashEntry trashEntry = TrashEntryLocalServiceUtil.getTrashEntry((long)restoreEntryId);
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)trashEntry.getClassPK());
            WikiPage page = WikiPageAttachmentsUtil.getPage(fileEntry.getFileEntryId());
            WikiPageServiceUtil.restorePageAttachmentFromTrash((long)page.getNodeId(), (String)page.getTitle(), (String)fileEntry.getTitle());
        }
    }
}

