/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.RequiredNodeException;
import com.liferay.portlet.wiki.WikiPortletInstanceSettings;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditNodeAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateNode(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteNode(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteNode(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeNode(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeNode(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e instanceof DuplicateNodeNameException || e instanceof NodeNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
            if (nodeId > 0L) {
                ActionUtil.getNode((PortletRequest)renderRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_node"));
    }

    protected void deleteNode(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int nodeCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodeCount == 1) {
            SessionErrors.add((PortletRequest)actionRequest, RequiredNodeException.class);
            return;
        }
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNode wikiNode = WikiNodeServiceUtil.getNode((long)nodeId);
        String oldName = wikiNode.getName();
        WikiCacheThreadLocal.setClearCache(false);
        WikiNode trashWikiNode = null;
        if (moveToTrash) {
            trashWikiNode = WikiNodeServiceUtil.moveNodeToTrash((long)nodeId);
        } else {
            WikiNodeServiceUtil.deleteNode((long)nodeId);
        }
        WikiCacheUtil.clearCache(nodeId);
        WikiCacheThreadLocal.setClearCache(true);
        WikiPortletInstanceSettings wikiPortletInstanceSettings = this.getWikiPortletInstanceSettings(actionRequest);
        this.updateSettings(wikiPortletInstanceSettings, oldName, "");
        if (moveToTrash && trashWikiNode != null) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, (TrashedModel)trashWikiNode);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected WikiPortletInstanceSettings getWikiPortletInstanceSettings(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        WikiPortletInstanceSettings wikiPortletInstanceSettings = WikiPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        return wikiPortletInstanceSettings;
    }

    protected void subscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.subscribeNode((long)nodeId);
    }

    protected void unsubscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.unsubscribeNode((long)nodeId);
    }

    protected void updateNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)actionRequest);
        if (nodeId <= 0L) {
            WikiNodeServiceUtil.addNode((String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            WikiNode wikiNode = WikiNodeServiceUtil.getNode((long)nodeId);
            String oldName = wikiNode.getName();
            WikiNodeServiceUtil.updateNode((long)nodeId, (String)name, (String)description, (ServiceContext)serviceContext);
            WikiPortletInstanceSettings wikiPortletInstanceSettings = this.getWikiPortletInstanceSettings(actionRequest);
            this.updateSettings(wikiPortletInstanceSettings, oldName, name);
        }
    }

    protected void updateSettings(WikiPortletInstanceSettings wikiPortletInstanceSettings, String oldName, String newName) throws Exception {
        String[] hiddenNodes = wikiPortletInstanceSettings.getHiddenNodes();
        ArrayUtil.replace((String[])hiddenNodes, (String)oldName, (String)newName);
        wikiPortletInstanceSettings.setHiddenNodes(hiddenNodes);
        String[] visibleNodes = wikiPortletInstanceSettings.getVisibleNodes();
        ArrayUtil.replace((String[])visibleNodes, (String)oldName, (String)newName);
        wikiPortletInstanceSettings.setVisibleNodes(visibleNodes);
        wikiPortletInstanceSettings.store();
    }
}

