/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode((PortletRequest)renderRequest);
            ActionUtil.getPage((PortletRequest)renderRequest);
            this.compareVersions(renderRequest, renderResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchPageException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return actionMapping.findForward("portlet.wiki.compare_versions");
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        double sourceVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterSourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterTargetVersion");
        String htmlDiffResult = this.getHtmlDiffResult(sourceVersion, targetVersion, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        resourceRequest.setAttribute("DIFF_HTML_RESULTS", (Object)htmlDiffResult);
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/taglib/ui/diff_version_comparator/diff_html.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void compareVersions(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title");
        double sourceVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"sourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"targetVersion");
        String htmlDiffResult = this.getHtmlDiffResult(sourceVersion, targetVersion, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        renderRequest.setAttribute("DIFF_HTML_RESULTS", (Object)htmlDiffResult);
        renderRequest.setAttribute("SOURCE_VERSION", (Object)sourceVersion);
        renderRequest.setAttribute("TARGET_VERSION", (Object)targetVersion);
        renderRequest.setAttribute("TITLE", (Object)title);
        renderRequest.setAttribute("WIKI_NODE_ID", (Object)nodeId);
    }

    protected String getHtmlDiffResult(double sourceVersion, double targetVersion, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)portletRequest, (String)"title");
        WikiPage sourcePage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)sourceVersion);
        WikiPage targetPage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)targetVersion);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
        PortletURL viewPageURL = liferayPortletResponse.createRenderURL();
        viewPageURL.setParameter("struts_action", "/wiki/view");
        WikiNode sourceNode = sourcePage.getNode();
        viewPageURL.setParameter("nodeName", sourceNode.getName());
        PortletURL editPageURL = liferayPortletResponse.createRenderURL();
        editPageURL.setParameter("struts_action", "/wiki/edit_page");
        editPageURL.setParameter("nodeId", String.valueOf(nodeId));
        editPageURL.setParameter("title", title);
        String attachmentURLPrefix = WikiUtil.getAttachmentURLPrefix(themeDisplay.getPathMain(), themeDisplay.getPlid(), nodeId, title);
        return WikiUtil.diffHtml(sourcePage, targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
    }
}

