/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static WikiNode getFirstVisibleNode(PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        WikiNode node = null;
        int nodesCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodesCount == 0) {
            Layout layout = themeDisplay.getLayout();
            serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)portletRequest);
            serviceContext.setAddGroupPermissions(true);
            if (layout.isPublicLayout()) {
                serviceContext.setAddGuestPermissions(true);
            } else {
                serviceContext.setAddGuestPermissions(false);
            }
        } else {
            node = WikiUtil.getFirstNode(portletRequest);
            if (node == null) {
                throw new PrincipalException();
            }
            return node;
        }
        node = WikiNodeLocalServiceUtil.addDefaultNode((long)themeDisplay.getDefaultUserId(), (ServiceContext)serviceContext);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiPage getFirstVisiblePage(long nodeId, PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        WikiPage page = WikiPageLocalServiceUtil.fetchPage((long)nodeId, (String)WikiPageConstants.FRONT_PAGE, (double)0.0);
        if (page == null) {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)portletRequest);
            Layout layout = themeDisplay.getLayout();
            serviceContext.setAddGroupPermissions(true);
            if (layout.isPublicLayout()) {
                serviceContext.setAddGuestPermissions(true);
            } else {
                serviceContext.setAddGuestPermissions(false);
            }
            boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
            try {
                WorkflowThreadLocal.setEnabled((boolean)false);
                page = WikiPageLocalServiceUtil.addPage((long)themeDisplay.getDefaultUserId(), (long)nodeId, (String)WikiPageConstants.FRONT_PAGE, null, (String)"New", (boolean)true, (ServiceContext)serviceContext);
            }
            finally {
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return page;
    }

    public static WikiNode getNode(PortletRequest portletRequest) throws Exception {
        WikiNode node;
        HttpServletRequest request;
        block4: {
            request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long nodeId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"nodeId");
            String nodeName = ParamUtil.getString((PortletRequest)portletRequest, (String)"nodeName");
            node = null;
            try {
                if (nodeId > 0L) {
                    node = WikiNodeServiceUtil.getNode((long)nodeId);
                    break block4;
                }
                if (Validator.isNotNull((String)nodeName)) {
                    node = WikiNodeServiceUtil.getNode((long)themeDisplay.getScopeGroupId(), (String)nodeName);
                    break block4;
                }
                throw new NoSuchNodeException();
            }
            catch (NoSuchNodeException nsne) {
                node = ActionUtil.getFirstVisibleNode(portletRequest);
            }
        }
        request.setAttribute("WIKI_NODE", (Object)node);
        return node;
    }

    public static void getPage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
        WikiNode node = null;
        try {
            if (nodeId > 0L) {
                node = WikiNodeServiceUtil.getNode((long)nodeId);
            }
        }
        catch (NoSuchNodeException nsne) {
            // empty catch block
        }
        if (node == null && (node = (WikiNode)request.getAttribute("WIKI_NODE")) != null) {
            nodeId = node.getNodeId();
        }
        if (Validator.isNull((String)title)) {
            title = WikiPageConstants.FRONT_PAGE;
        }
        WikiPage page = null;
        try {
            page = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            if (page.isDraft()) {
                StringBundler sb = new StringBundler(7);
                sb.append("{nodeId=");
                sb.append(nodeId);
                sb.append(", title=");
                sb.append(title);
                sb.append(", version=");
                sb.append(version);
                sb.append("}");
                throw new NoSuchPageException(sb.toString());
            }
        }
        catch (NoSuchPageException nspe) {
            if (title.equals(WikiPageConstants.FRONT_PAGE) && version == 0.0) {
                page = ActionUtil.getFirstVisiblePage(nodeId, portletRequest);
            }
            throw nspe;
        }
        request.setAttribute("WIKI_PAGE", (Object)page);
    }
}

