/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import java.util.Map;

public class WikiSettings {
    public static String[] ALL_KEYS = new String[]{"emailFromAddress", "emailFromName", "emailPageAddedBody", "emailPageAddedSubject", "emailPageUpdatedBody", "emailPageUpdatedSubject", "emailPageAddedEnabled", "emailPageUpdatedEnabled"};
    private static final String[] _MULTI_VALUED_KEYS = new String[0];
    private TypedSettings _typedSettings;

    public static WikiSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.wiki");
        return new WikiSettings(settings);
    }

    public static WikiSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.wiki");
        return new WikiSettings((Settings)new ParameterMapSettings(parameterMap, settings));
    }

    public WikiSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public LocalizedValuesMap getEmailPageAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailPageAddedBody");
    }

    public String getEmailPageAddedBodyXml() {
        LocalizedValuesMap emailPageAddedBodyMap = this.getEmailPageAddedBody();
        return emailPageAddedBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailPageAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailPageAddedSubject");
    }

    public String getEmailPageAddedSubjectXml() {
        LocalizedValuesMap emailPageAddedSubjectMap = this.getEmailPageAddedSubject();
        return emailPageAddedSubjectMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailPageUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailPageUpdatedBody");
    }

    public String getEmailPageUpdatedBodyXml() {
        LocalizedValuesMap emailPageUpdatedBodyMap = this.getEmailPageUpdatedBody();
        return emailPageUpdatedBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailPageUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailPageUpdatedSubject");
    }

    public String getEmailPageUpdatedSubjectXml() {
        LocalizedValuesMap emailPageUpdatedSubjectMap = this.getEmailPageUpdatedSubject();
        return emailPageUpdatedSubjectMap.getLocalizationXml();
    }

    public boolean isEmailPageAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailPageAddedEnabled");
    }

    public boolean isEmailPageUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailPageUpdatedEnabled");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("emailFromAddress", new String[]{"wiki.email.from.address", "admin.email.from.address"});
        fallbackKeys.add("emailFromName", new String[]{"wiki.email.from.name", "admin.email.from.name"});
        fallbackKeys.add("emailPageAddedBody", new String[]{"wiki.email.page.added.body"});
        fallbackKeys.add("emailPageAddedEnabled", new String[]{"wiki.email.page.added.enabled"});
        fallbackKeys.add("emailPageAddedSubject", new String[]{"wiki.email.page.added.subject"});
        fallbackKeys.add("emailPageUpdatedBody", new String[]{"wiki.email.page.updated.body"});
        fallbackKeys.add("emailPageUpdatedEnabled", new String[]{"wiki.email.page.updated.enabled"});
        fallbackKeys.add("emailPageUpdatedSubject", new String[]{"wiki.email.page.updated.subject"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("com.liferay.portlet.wiki", WikiSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

