/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.model.Layout;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ValidatorException;

public class WikiPortletInstanceSettings {
    public static final String[] ALL_KEYS = new String[]{"displayStyle", "displayStyleGroupId", "hiddenNodes", "rssDelta", "rssDisplayStyle", "rssFeedType", "visibleNodes", "enableCommentRatings", "enableComments", "enablePageRatings", "enableRelatedAssets", "enableRss", "hiddenNodes", "visibleNodes"};
    private static final String[] _MULTI_VALUED_KEYS = new String[]{"hiddenNodes", "visibleNodes"};
    private TypedSettings _typedSettings;

    public static WikiPortletInstanceSettings getInstance(Layout layout, String portletId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        return new WikiPortletInstanceSettings(settings);
    }

    public static WikiPortletInstanceSettings getInstance(Layout layout, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        return new WikiPortletInstanceSettings((Settings)new ParameterMapSettings(parameterMap, settings));
    }

    public WikiPortletInstanceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getDisplayStyle() {
        return this._typedSettings.getValue("displayStyle");
    }

    public long getDisplayStyleGroupId(long defaultDisplayStyleGroupId) {
        return this._typedSettings.getLongValue("displayStyleGroupId", defaultDisplayStyleGroupId);
    }

    public String[] getHiddenNodes() {
        return this._typedSettings.getValues("hiddenNodes");
    }

    public int getRssDelta() {
        return this._typedSettings.getIntegerValue("rssDelta");
    }

    public String getRssDisplayStyle() {
        return this._typedSettings.getValue("rssDisplayStyle");
    }

    public String getRssFeedType() {
        return this._typedSettings.getValue("rssFeedType");
    }

    public String[] getVisibleNodes() {
        return this._typedSettings.getValues("visibleNodes");
    }

    public boolean isEnableCommentRatings() {
        return this._typedSettings.getBooleanValue("enableCommentRatings");
    }

    public boolean isEnableComments() {
        return this._typedSettings.getBooleanValue("enableComments");
    }

    public boolean isEnablePageRatings() {
        return this._typedSettings.getBooleanValue("enablePageRatings");
    }

    public boolean isEnableRelatedAssets() {
        return this._typedSettings.getBooleanValue("enableRelatedAssets");
    }

    public boolean isEnableRSS() {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            return false;
        }
        return this._typedSettings.getBooleanValue("enableRss");
    }

    public void setHiddenNodes(String[] hiddenNodes) {
        this._typedSettings.setValues("hiddenNodes", hiddenNodes);
    }

    public void setVisibleNodes(String[] visibleNodes) {
        this._typedSettings.setValues("visibleNodes", visibleNodes);
    }

    public void store() throws IOException, ValidatorException {
        Settings settings = this._typedSettings.getWrappedSettings();
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.store();
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("displayStyle", new String[]{"wiki.display.style"});
        fallbackKeys.add("enableComments", new String[]{"wiki.page.comments.enabled"});
        fallbackKeys.add("enableCommentRatings", new String[]{"wiki.comment.ratings.enabled"});
        fallbackKeys.add("enablePageRatings", new String[]{"wiki.page.ratings.enabled"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"wiki.related.assets.enabled"});
        fallbackKeys.add("enableRss", new String[]{"wiki.rss.enabled"});
        fallbackKeys.add("rssDelta", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("rssDisplayStyle", new String[]{"rss.feed.display.style.default"});
        fallbackKeys.add("rssFeedType", new String[]{"rss.feed.type.default"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("36", WikiPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("154", WikiPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("54", WikiPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

