/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserOrganizationChecker
extends RowChecker {
    private static Log _log = LogFactoryUtil.getLog(UserOrganizationChecker.class);
    private Organization _organization;

    public UserOrganizationChecker(RenderResponse renderResponse, Organization organization) {
        super((PortletResponse)renderResponse);
        this._organization = organization;
    }

    public boolean isChecked(Object obj) {
        User user = (User)obj;
        try {
            return UserLocalServiceUtil.hasOrganizationUser((long)this._organization.getOrganizationId(), (long)user.getUserId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isDisabled(Object obj) {
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT) {
            return false;
        }
        User user = (User)obj;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)user.getUserId(), (long)this._organization.getOrganizationId()) || OrganizationMembershipPolicyUtil.isMembershipRequired((long)user.getUserId(), (long)this._organization.getOrganizationId()) : !OrganizationMembershipPolicyUtil.isMembershipAllowed((long)user.getUserId(), (long)this._organization.getOrganizationId())) {
                return true;
            }
            return !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"UPDATE");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return super.isDisabled(obj);
        }
    }
}

