/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.Website;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.WebsiteLocalServiceUtil;

public class WebsiteStagedModelDataHandler
extends BaseStagedModelDataHandler<Website> {
    public static final String[] CLASS_NAMES = new String[]{Website.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Website website = this.fetchStagedModelByUuidAndCompanyId(uuid, group.getCompanyId());
        if (website != null) {
            WebsiteLocalServiceUtil.deleteWebsite((Website)website);
        }
    }

    public Website fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        return WebsiteLocalServiceUtil.fetchWebsiteByUuidAndCompanyId((String)uuid, (long)companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Website website) throws Exception {
        Element websiteElement = portletDataContext.getExportDataElement((ClassedModel)website);
        portletDataContext.addClassedModel(websiteElement, ExportImportPathUtil.getModelPath((StagedModel)website), (ClassedModel)website);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Website website) throws Exception {
        long userId = portletDataContext.getUserId(website.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)website);
        Website existingWebsite = this.fetchStagedModelByUuidAndCompanyId(website.getUuid(), portletDataContext.getCompanyGroupId());
        Website importedWebsite = null;
        if (existingWebsite == null) {
            serviceContext.setUuid(website.getUuid());
            importedWebsite = WebsiteLocalServiceUtil.addWebsite((long)userId, (String)website.getClassName(), (long)website.getClassPK(), (String)website.getUrl(), (int)website.getTypeId(), (boolean)website.isPrimary(), (ServiceContext)serviceContext);
        } else {
            importedWebsite = WebsiteLocalServiceUtil.updateWebsite((long)existingWebsite.getWebsiteId(), (String)website.getUrl(), (int)website.getTypeId(), (boolean)website.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)website, (ClassedModel)importedWebsite);
    }
}

