/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.action;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class ExportUsersAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String csv = this.getUsersCSV(actionRequest, actionResponse);
            String fileName = "users.csv";
            byte[] bytes = csv.getBytes();
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)"text/csv; charset=UTF-8");
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            this.setForward((PortletRequest)actionRequest, "portlet.users_admin.error");
        }
    }

    protected String getUserCSV(User user) {
        StringBundler sb = new StringBundler(PropsValues.USERS_EXPORT_CSV_FIELDS.length * 2);
        for (int i = 0; i < PropsValues.USERS_EXPORT_CSV_FIELDS.length; ++i) {
            String field = PropsValues.USERS_EXPORT_CSV_FIELDS[i];
            if (field.equals("fullName")) {
                sb.append(CSVUtil.encode((String)user.getFullName()));
            } else if (field.startsWith("expando:")) {
                String attributeName = field.substring(8);
                ExpandoBridge expandoBridge = user.getExpandoBridge();
                sb.append(CSVUtil.encode((Object)expandoBridge.getAttribute(attributeName)));
            } else {
                sb.append(CSVUtil.encode((String)BeanPropertiesUtil.getString((Object)user, (String)field)));
            }
            if (i + 1 >= PropsValues.USERS_EXPORT_CSV_FIELDS.length) continue;
            sb.append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    protected List<User> getUsers(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userGroupId;
        User user;
        Long[] organizationIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        boolean exportAllUsers = PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"EXPORT_USER");
        if (!exportAllUsers && !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"125", (String)"EXPORT_USER")) {
            return Collections.emptyList();
        }
        LiferayPortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL("125");
        UserSearch userSearch = new UserSearch((PortletRequest)actionRequest, (PortletURL)portletURL);
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        long organizationId = searchTerms.getOrganizationId();
        if (organizationId > 0L) {
            params.put("usersOrgs", new Long(organizationId));
        } else if (!exportAllUsers && (organizationIds = ArrayUtil.toArray((long[])(user = themeDisplay.getUser()).getOrganizationIds(true))).length > 0) {
            params.put("usersOrgs", organizationIds);
        }
        long roleId = searchTerms.getRoleId();
        if (roleId > 0L) {
            params.put("usersRoles", new Long(roleId));
        }
        if ((userGroupId = searchTerms.getUserGroupId()) > 0L) {
            params.put("usersUserGroups", new Long(userGroupId));
        }
        if (PropsValues.USERS_INDEXER_ENABLED && PropsValues.USERS_SEARCH_WITH_INDEX) {
            params.put("expandoAttributes", searchTerms.getKeywords());
            Hits hits = null;
            hits = searchTerms.isAdvancedSearch() ? UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getFirstName(), (String)searchTerms.getMiddleName(), (String)searchTerms.getLastName(), (String)searchTerms.getScreenName(), (String)searchTerms.getEmailAddress(), (int)searchTerms.getStatus(), params, (boolean)searchTerms.isAndOperator(), (int)-1, (int)-1, (Sort)null) : UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), params, (int)-1, (int)-1, (Sort)null);
            return UsersAdminUtil.getUsers((Hits)hits);
        }
        if (searchTerms.isAdvancedSearch()) {
            return UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getFirstName(), (String)searchTerms.getMiddleName(), (String)searchTerms.getLastName(), (String)searchTerms.getScreenName(), (String)searchTerms.getEmailAddress(), (int)searchTerms.getStatus(), params, (boolean)searchTerms.isAndOperator(), (int)-1, (int)-1, (OrderByComparator)null);
        }
        return UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), params, (int)-1, (int)-1, (OrderByComparator)null);
    }

    protected String getUsersCSV(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        List<User> users = this.getUsers(actionRequest, actionResponse);
        if (users.isEmpty()) {
            return "";
        }
        String exportProgressId = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportProgressId");
        ProgressTracker progressTracker = new ProgressTracker(exportProgressId);
        progressTracker.start((PortletRequest)actionRequest);
        int percentage = 10;
        int total = users.size();
        progressTracker.setPercent(percentage);
        StringBundler sb = new StringBundler(users.size());
        for (int i = 0; i < users.size(); ++i) {
            User user = users.get(i);
            sb.append(this.getUserCSV(user));
            percentage = Math.min(10 + i * 90 / total, 99);
            progressTracker.setPercent(percentage);
        }
        progressTracker.finish((PortletRequest)actionRequest);
        return sb.toString();
    }
}

