/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.action;

import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.DuplicateOrganizationException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.OrganizationNameException;
import com.liferay.portal.OrganizationParentException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.RequiredOrganizationException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.portlet.usersadmin.action.ActionUtil;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.io.InputStream;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditOrganizationAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Organization organization = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                organization = this.updateOrganization(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteOrganizations(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (organization != null) {
                redirect = HttpUtil.setParameter((String)redirect, (String)(actionResponse.getNamespace() + "organizationId"), (long)organization.getOrganizationId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.users_admin.error");
            }
            if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof DuplicateOrganizationException || e instanceof EmailAddressException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException || e instanceof OrganizationNameException || e instanceof OrganizationParentException || e instanceof PhoneNumberException || e instanceof RequiredOrganizationException || e instanceof WebsiteURLException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(e.getClass().getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
                if (e instanceof RequiredOrganizationException) {
                    String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
                    if (organizationId > 0L) {
                        redirect = HttpUtil.setParameter((String)redirect, (String)(actionResponse.getNamespace() + "organizationId"), (long)organizationId);
                    }
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getOrganization((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.users_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.users_admin.edit_organization"));
    }

    protected void deleteOrganizations(ActionRequest actionRequest) throws Exception {
        long[] deleteOrganizationIds;
        for (long deleteOrganizationId : deleteOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrganizationIds"), (long)0L)) {
            OrganizationServiceUtil.deleteOrganization((long)deleteOrganizationId);
        }
    }

    protected Organization updateOrganization(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long parentOrganizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentOrganizationSearchContainerPrimaryKeys", (long)0L);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int statusId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"statusId");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"regionId");
        long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"countryId");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        boolean site = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"site");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        List orgLabors = UsersAdminUtil.getOrgLabors((ActionRequest)actionRequest);
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Organization.class.getName(), (PortletRequest)actionRequest);
        Organization organization = null;
        organization = organizationId <= 0L ? OrganizationServiceUtil.addOrganization((long)parentOrganizationId, (String)name, (String)type, (long)regionId, (long)countryId, (int)statusId, (String)comments, (boolean)site, (List)addresses, (List)emailAddresses, (List)orgLabors, (List)phones, (List)websites, (ServiceContext)serviceContext) : OrganizationServiceUtil.updateOrganization((long)organizationId, (long)parentOrganizationId, (String)name, (String)type, (long)regionId, (long)countryId, (int)statusId, (String)comments, (!deleteLogo ? 1 : 0) != 0, (byte[])logoBytes, (boolean)site, (List)addresses, (List)emailAddresses, (List)orgLabors, (List)phones, (List)websites, (ServiceContext)serviceContext);
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (publicLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (privateLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        Group organizationGroup = organization.getGroup();
        if (GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)organizationGroup, (String)"UPDATE")) {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)organizationGroup, (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
        String reminderQueries = actionRequest.getParameter("reminderQueries");
        PortletPreferences portletPreferences = organization.getPreferences();
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)actionRequest, (PortletPreferences)portletPreferences, (String)"reminderQueries");
        portletPreferences.setValue("reminderQueries", reminderQueries);
        portletPreferences.store();
        return organization;
    }
}

