/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usergroupsadmin.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class UserGroupIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{UserGroup.class.getName()};
    public static final String PORTLET_ID = "127";

    public UserGroupIndexer() {
        this.setCommitImmediately(true);
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "uid", "userGroupId"});
        this.setIndexerEnabled(PropsValues.USER_GROUPS_INDEXER_ENABLED);
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        UserGroup userGroup = (UserGroup)obj;
        this.deleteDocument(userGroup.getCompanyId(), userGroup.getUserGroupId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        UserGroup userGroup = (UserGroup)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)userGroup);
        document.addKeyword("companyId", userGroup.getCompanyId());
        document.addText("description", userGroup.getDescription());
        document.addText("name", userGroup.getName());
        document.addKeyword("userGroupId", userGroup.getUserGroupId());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("description")) {
            return "description";
        }
        if (orderByCol.equals("name")) {
            return "name";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        String title = document.get("name");
        String content = null;
        String userGroupId = document.get("userGroupId");
        portletURL.setParameter("struts_action", "/users_admin/edit_user_group");
        portletURL.setParameter("userGroupId", userGroupId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof Long) {
            long userGroupId = (Long)obj;
            UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupId);
            this.doReindex(userGroup);
        } else if (obj instanceof long[]) {
            long[] userGroupIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            for (long userGroupId : userGroupIds) {
                UserGroup userGroup = UserGroupLocalServiceUtil.fetchUserGroup((long)userGroupId);
                if (userGroup == null) continue;
                Document document = this.getDocument(userGroup);
                long companyId = userGroup.getCompanyId();
                ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                if (documents == null) {
                    documents = new ArrayList<Document>();
                    documentsMap.put(companyId, documents);
                }
                documents.add(document);
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, (Collection)documents, (boolean)this.isCommitImmediately());
            }
        } else if (obj instanceof UserGroup) {
            UserGroup userGroup = (UserGroup)obj;
            Document document = this.getDocument(userGroup);
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)userGroup.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)classPK);
        this.doReindex(userGroup);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexUserGroups(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexUserGroups(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = UserGroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                UserGroup userGroup = (UserGroup)object;
                Document document = UserGroupIndexer.this.getDocument(userGroup);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

