/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usergroupsadmin.action;

import com.liferay.portal.DuplicateUserGroupException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.RequiredUserGroupException;
import com.liferay.portal.UserGroupNameException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.portlet.usergroupsadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditUserGroupAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateUserGroup(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteUserGroups(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.user_groups_admin.error");
            }
            if (e instanceof DuplicateUserGroupException || e instanceof NoSuchUserGroupException || e instanceof RequiredUserGroupException || e instanceof UserGroupNameException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                if (cmd.equals("delete") && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getUserGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.user_groups_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.user_groups_admin.edit_user_group"));
    }

    protected void deleteUserGroups(ActionRequest actionRequest) throws Exception {
        long[] deleteUserGroupIds;
        for (long deleteUserGroupId : deleteUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserGroupIds"), (long)0L)) {
            UserGroupServiceUtil.deleteUserGroup((long)deleteUserGroupId);
        }
    }

    protected void updateUserGroup(ActionRequest actionRequest) throws Exception {
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)UserGroup.class.getName(), (PortletRequest)actionRequest);
        UserGroup userGroup = null;
        userGroup = userGroupId <= 0L ? UserGroupServiceUtil.addUserGroup((String)name, (String)description, (ServiceContext)serviceContext) : UserGroupServiceUtil.updateUserGroup((long)userGroupId, (String)name, (String)description, (ServiceContext)serviceContext);
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled");
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled");
        if (privateLayoutSetPrototypeId > 0L || publicLayoutSetPrototypeId > 0L) {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)userGroup.getGroup(), (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
    }
}

