/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.trash.model.TrashEntry;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class TrashIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{TrashEntry.class.getName()};
    public static final String PORTLET_ID = "182";

    public TrashIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "removedByUserName", "removedDate", "rootEntryClassName", "rootEntryClassPK"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            contextQuery.addRequiredTerm("companyId", searchContext.getCompanyId());
            BooleanQuery excludeAttachmentsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            excludeAttachmentsQuery.addRequiredTerm("entryClassName", DLFileEntryConstants.getClassName());
            excludeAttachmentsQuery.addRequiredTerm("hidden", true);
            contextQuery.add((Query)excludeAttachmentsQuery, BooleanClauseOccur.MUST_NOT);
            BooleanQuery excludeJournalArticleVersionsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            excludeJournalArticleVersionsQuery.addRequiredTerm("entryClassName", JournalArticle.class.getName());
            excludeJournalArticleVersionsQuery.addRequiredTerm("head", false);
            contextQuery.add((Query)excludeJournalArticleVersionsQuery, BooleanClauseOccur.MUST_NOT);
            BooleanQuery groupQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (long groupId : searchContext.getGroupIds()) {
                groupQuery.addTerm("groupId", String.valueOf(groupId), false, BooleanClauseOccur.SHOULD);
            }
            contextQuery.add((Query)groupQuery, BooleanClauseOccur.MUST);
            contextQuery.addRequiredTerm("status", 8);
            BooleanQuery fullQuery = this.createFullQuery(contextQuery, searchContext);
            return fullQuery;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entryClassName);
        return trashHandler.hasTrashPermission(permissionChecker, 0L, entryClassPK, actionId);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        if (searchContext.getAttributes() == null) {
            return;
        }
        this.addSearchTerm(searchQuery, searchContext, "content", true);
        this.addSearchTerm(searchQuery, searchContext, "removedByUserName", true);
        this.addSearchTerm(searchQuery, searchContext, "title", true);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", true);
    }

    protected void doDelete(Object obj) {
    }

    protected Document doGetDocument(Object obj) {
        return null;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("removed-date")) {
            return "removedDate";
        }
        if (orderByCol.equals("removed-by")) {
            return "removedByUserName";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Object obj) {
    }

    protected void doReindex(String className, long classPK) {
    }

    protected void doReindex(String[] ids) {
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }
}

