/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.translator.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portlet.translator.model.Translation;
import com.liferay.portlet.translator.util.TranslationWebCacheItem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class TranslatorUtil {
    public static String[] getFromAndToLanguageIds(String translationId, Map<String, String> languageIdsMap) {
        try {
            int pos = translationId.indexOf("_");
            String fromLanguageId = translationId.substring(0, pos);
            if (!languageIdsMap.containsKey(fromLanguageId) && !languageIdsMap.containsKey(fromLanguageId = translationId.substring(0, pos = translationId.indexOf("_", pos + 1)))) {
                return null;
            }
            String toLanguageId = translationId.substring(pos + 1);
            if (!languageIdsMap.containsKey(fromLanguageId)) {
                return null;
            }
            return new String[]{fromLanguageId, toLanguageId};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map<String, String> getLanguageIdsMap(Locale locale) {
        String[] languageIds;
        HashMap<String, String> languageIdsMap = new HashMap<String, String>();
        for (String languageId : languageIds = PrefsPropsUtil.getStringArray((String)"translator.languages", (String)",")) {
            languageIdsMap.put(languageId, LanguageUtil.get((Locale)locale, (String)("language." + languageId)));
        }
        TreeMap<Object, String> sortedLanguageIdsMap = new TreeMap<Object, String>(new ValueComparator(languageIdsMap));
        sortedLanguageIdsMap.putAll(languageIdsMap);
        return sortedLanguageIdsMap;
    }

    public static Translation getTranslation(String fromLanguageId, String toLanguageId, String fromText) throws WebCacheException {
        TranslationWebCacheItem wci = new TranslationWebCacheItem(fromLanguageId, toLanguageId, fromText);
        return (Translation)wci.convert("");
    }

    private static class ValueComparator
    implements Comparator<Object> {
        private Map<String, String> _map;

        public ValueComparator(Map<String, String> map) {
            this._map = map;
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            String value1 = this._map.get(obj1);
            String value2 = this._map.get(obj2);
            return value1.compareTo(value2);
        }
    }
}

