/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.service.SCLicenseLocalServiceUtil;

public class SCLicensePermission {
    public static void check(PermissionChecker permissionChecker, long productEntryId, String actionId) throws PortalException {
        if (!SCLicensePermission.contains(permissionChecker, productEntryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, SCLicense license, String actionId) throws PortalException {
        if (!SCLicensePermission.contains(permissionChecker, license, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long licenseId, String actionId) throws PortalException {
        SCLicense license = SCLicenseLocalServiceUtil.getLicense((long)licenseId);
        return SCLicensePermission.contains(permissionChecker, license, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, SCLicense license, String actionId) {
        return permissionChecker.hasPermission(0L, SCLicense.class.getName(), license.getLicenseId(), actionId);
    }
}

