/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.service.SCFrameworkVersionLocalServiceUtil;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion"})
public class SCFrameworkVersionPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long frameworkVersionId, String actionId) throws PortalException {
        if (!SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersionId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, SCFrameworkVersion frameworkVersion, String actionId) throws PortalException {
        if (!SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersion, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long frameworkVersionId, String actionId) throws PortalException {
        SCFrameworkVersion frameworkVersion = SCFrameworkVersionLocalServiceUtil.getFrameworkVersion((long)frameworkVersionId);
        return SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersion, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, SCFrameworkVersion frameworkVersion, String actionId) {
        if (permissionChecker.hasOwnerPermission(frameworkVersion.getCompanyId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), frameworkVersion.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(frameworkVersion.getGroupId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        SCFrameworkVersionPermission.check(permissionChecker, primaryKey, actionId);
    }
}

