/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.base.SCProductVersionServiceBaseImpl;
import com.liferay.portlet.softwarecatalog.service.permission.SCProductEntryPermission;
import java.util.List;

public class SCProductVersionServiceImpl
extends SCProductVersionServiceBaseImpl {
    public SCProductVersion addProductVersion(long productEntryId, String version, String changeLog, String downloadPageURL, String directDownloadURL, boolean testDirectDownloadURL, boolean repoStoreArtifact, long[] frameworkVersionIds, ServiceContext serviceContext) throws PortalException {
        SCProductEntryPermission.check(this.getPermissionChecker(), productEntryId, "UPDATE");
        return this.scProductVersionLocalService.addProductVersion(this.getUserId(), productEntryId, version, changeLog, downloadPageURL, directDownloadURL, testDirectDownloadURL, repoStoreArtifact, frameworkVersionIds, serviceContext);
    }

    public void deleteProductVersion(long productVersionId) throws PortalException {
        SCProductVersion productVersion = this.scProductVersionLocalService.getProductVersion(productVersionId);
        SCProductEntryPermission.check(this.getPermissionChecker(), productVersion.getProductEntryId(), "UPDATE");
        this.scProductVersionLocalService.deleteProductVersion(productVersionId);
    }

    public SCProductVersion getProductVersion(long productVersionId) throws PortalException {
        SCProductVersion productVersion = this.scProductVersionLocalService.getProductVersion(productVersionId);
        SCProductEntryPermission.check(this.getPermissionChecker(), productVersion.getProductEntryId(), "VIEW");
        return productVersion;
    }

    public List<SCProductVersion> getProductVersions(long productEntryId, int start, int end) throws PortalException {
        SCProductEntryPermission.check(this.getPermissionChecker(), productEntryId, "VIEW");
        return this.scProductVersionLocalService.getProductVersions(productEntryId, start, end);
    }

    public int getProductVersionsCount(long productEntryId) throws PortalException {
        SCProductEntryPermission.check(this.getPermissionChecker(), productEntryId, "VIEW");
        return this.scProductVersionLocalService.getProductVersionsCount(productEntryId);
    }

    public SCProductVersion updateProductVersion(long productVersionId, String version, String changeLog, String downloadPageURL, String directDownloadURL, boolean testDirectDownloadURL, boolean repoStoreArtifact, long[] frameworkVersionIds) throws PortalException {
        SCProductVersion productVersion = this.scProductVersionLocalService.getProductVersion(productVersionId);
        SCProductEntryPermission.check(this.getPermissionChecker(), productVersion.getProductEntryId(), "UPDATE");
        return this.scProductVersionLocalService.updateProductVersion(productVersionId, version, changeLog, downloadPageURL, directDownloadURL, testDirectDownloadURL, repoStoreArtifact, frameworkVersionIds);
    }
}

