/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.softwarecatalog.LicenseNameException;
import com.liferay.portlet.softwarecatalog.RequiredLicenseException;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.service.base.SCLicenseLocalServiceBaseImpl;
import java.util.List;

public class SCLicenseLocalServiceImpl
extends SCLicenseLocalServiceBaseImpl {
    public SCLicense addLicense(String name, String url, boolean openSource, boolean active, boolean recommended) throws PortalException {
        this.validate(name);
        long licenseId = this.counterLocalService.increment();
        SCLicense license = this.scLicensePersistence.create(licenseId);
        license.setName(name);
        license.setUrl(url);
        license.setOpenSource(openSource);
        license.setActive(active);
        license.setRecommended(recommended);
        this.scLicensePersistence.update((BaseModel)license);
        return license;
    }

    public void deleteLicense(long licenseId) throws PortalException {
        SCLicense license = this.scLicensePersistence.findByPrimaryKey(licenseId);
        if (this.scLicensePersistence.getSCProductEntriesSize(licenseId) > 0) {
            throw new RequiredLicenseException();
        }
        this.deleteLicense(license);
    }

    public void deleteLicense(SCLicense license) {
        this.scLicensePersistence.remove((BaseModel)license);
    }

    public SCLicense getLicense(long licenseId) throws PortalException {
        return this.scLicensePersistence.findByPrimaryKey(licenseId);
    }

    public List<SCLicense> getLicenses() {
        return this.scLicensePersistence.findAll();
    }

    public List<SCLicense> getLicenses(boolean active, boolean recommended) {
        return this.scLicensePersistence.findByA_R(active, recommended);
    }

    public List<SCLicense> getLicenses(boolean active, boolean recommended, int start, int end) {
        return this.scLicensePersistence.findByA_R(active, recommended, start, end);
    }

    public List<SCLicense> getLicenses(int start, int end) {
        return this.scLicensePersistence.findAll(start, end);
    }

    public int getLicensesCount() {
        return this.scLicensePersistence.countAll();
    }

    public int getLicensesCount(boolean active, boolean recommended) {
        return this.scLicensePersistence.countByA_R(active, recommended);
    }

    public List<SCLicense> getProductEntryLicenses(long productEntryId) {
        return this.scProductEntryPersistence.getSCLicenses(productEntryId);
    }

    public SCLicense updateLicense(long licenseId, String name, String url, boolean openSource, boolean active, boolean recommended) throws PortalException {
        this.validate(name);
        SCLicense license = this.scLicensePersistence.findByPrimaryKey(licenseId);
        license.setName(name);
        license.setUrl(url);
        license.setOpenSource(openSource);
        license.setActive(active);
        license.setRecommended(recommended);
        this.scLicensePersistence.update((BaseModel)license);
        return license;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LicenseNameException();
        }
    }
}

