/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.socialactivity.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivitySetting;
import com.liferay.portlet.social.service.SocialActivitySettingServiceUtil;
import com.liferay.portlet.social.util.SocialConfigurationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("update")) {
                this.updateActivitySettings(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            renderRequest.setAttribute("SOCIAL_ACTIVITY_SETTINGS_MAP", this.getActivitySettingsMap(themeDisplay));
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.social_activity.error");
            }
            throw e;
        }
        return actionMapping.findForward("portlet.social_activity.view");
    }

    protected Map<String, Boolean> getActivitySettingsMap(ThemeDisplay themeDisplay) throws Exception {
        LinkedHashMap<String, Boolean> activitySettingsMap = new LinkedHashMap<String, Boolean>();
        List activitySettings = SocialActivitySettingServiceUtil.getActivitySettings((long)themeDisplay.getSiteGroupIdOrLiveGroupId());
        String[] modelNames = SocialConfigurationUtil.getActivityModelNames();
        ModelResourceComparator comparator = new ModelResourceComparator(themeDisplay.getLocale());
        Arrays.sort(modelNames, comparator);
        block0: for (String modelName : modelNames) {
            List activityDefinitions = SocialActivitySettingServiceUtil.getActivityDefinitions((long)themeDisplay.getScopeGroupId(), (String)modelName);
            for (SocialActivityDefinition activityDefinition : activityDefinitions) {
                if (!activityDefinition.isCountersEnabled()) continue;
                activitySettingsMap.put(modelName, false);
                continue block0;
            }
        }
        for (SocialActivitySetting activitySetting : activitySettings) {
            String name = activitySetting.getName();
            if (!name.equals("enabled") || !activitySettingsMap.containsKey(activitySetting.getClassName())) continue;
            activitySettingsMap.put(activitySetting.getClassName(), GetterUtil.getBoolean((String)activitySetting.getValue()));
        }
        return activitySettingsMap;
    }

    protected SocialActivityCounterDefinition updateActivityCounterDefinition(JSONObject actionJSONObject, SocialActivityDefinition activityDefinition, String activityCounterName) {
        SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(activityCounterName);
        if (activityCounterDefinition == null) {
            activityCounterDefinition = new SocialActivityCounterDefinition();
            activityCounterDefinition.setName(activityCounterName);
        }
        if (activityCounterName.equals("contribution")) {
            activityCounterDefinition.setOwnerType(3);
        } else if (activityCounterName.equals("participation")) {
            activityCounterDefinition.setOwnerType(1);
        } else if (activityCounterName.equals("popularity")) {
            activityCounterDefinition.setOwnerType(2);
            activityCounterName = "contribution";
        } else {
            throw new IllegalArgumentException();
        }
        activityCounterDefinition.setEnabled(actionJSONObject.getBoolean("active"));
        activityCounterDefinition.setIncrement(actionJSONObject.getInt(activityCounterName + "Increment"));
        activityCounterDefinition.setLimitPeriod(actionJSONObject.getInt(activityCounterName + "LimitPeriod"));
        activityCounterDefinition.setLimitValue(actionJSONObject.getInt(activityCounterName + "LimitValue"));
        return activityCounterDefinition;
    }

    protected void updateActivitySettings(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String settingsJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"settingsJSON");
        JSONObject settingsJSONObject = JSONFactoryUtil.createJSONObject((String)settingsJSON);
        JSONArray actionsJSONArray = settingsJSONObject.getJSONArray("actions");
        String modelName = settingsJSONObject.getString("modelName");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            int activityType = actionJSONObject.getInt("activityType");
            SocialActivityDefinition activityDefinition = SocialActivitySettingServiceUtil.getActivityDefinition((long)themeDisplay.getSiteGroupIdOrLiveGroupId(), (String)modelName, (int)activityType);
            if (activityDefinition == null) continue;
            ArrayList<SocialActivityCounterDefinition> activityCounterDefinitions = new ArrayList<SocialActivityCounterDefinition>();
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "contribution"));
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "participation"));
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "popularity"));
            SocialActivitySettingServiceUtil.updateActivitySettings((long)themeDisplay.getSiteGroupIdOrLiveGroupId(), (String)modelName, (int)activityType, activityCounterDefinitions);
        }
    }
}

